/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.hessian;

import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.protocol.hessian.HttpClientConnection;
import com.caucho.hessian.client.HessianConnection;
import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import java.io.IOException;
import java.net.URL;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpClientConnectionFactory
implements HessianConnectionFactory {
    private HttpClient httpClient;

    public void setHessianProxyFactory(HessianProxyFactory factory) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)factory.getConnectTimeout()).setSocketTimeout((int)factory.getReadTimeout()).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public HessianConnection open(URL url) throws IOException {
        HttpClientConnection httpClientConnection = new HttpClientConnection(this.httpClient, url);
        RpcContext context = RpcContext.getContext();
        for (String key : context.getAttachments().keySet()) {
            httpClientConnection.addHeader("header" + key, context.getAttachment(key));
        }
        return httpClientConnection;
    }
}

