/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.database.interceptor;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.security.database.algorithm.EncryptAlgorithmApi;
import cn.stylefeng.roses.kernel.security.database.annotation.EncryptField;
import cn.stylefeng.roses.kernel.security.database.annotation.ProtectedData;
import cn.stylefeng.roses.kernel.security.database.annotation.ProtectedField;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class ParameterInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ParameterInterceptor.class);
    @Autowired
    private EncryptAlgorithmApi encryptAlgorithmApi;

    public Object intercept(Invocation invocation) throws Throwable {
        Class<?> parameterObjectClass;
        ProtectedData protectedData;
        ParameterHandler parameterHandler = (ParameterHandler)invocation.getTarget();
        Field parameterField = parameterHandler.getClass().getDeclaredField("parameterObject");
        parameterField.setAccessible(true);
        Object parameterObject = parameterField.get(parameterHandler);
        if (parameterObject != null && ObjectUtil.isNotNull((Object)(protectedData = (ProtectedData)AnnotationUtils.findAnnotation(parameterObjectClass = parameterObject.getClass(), ProtectedData.class)))) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = parameterObjectClass.getDeclaredFields()) {
                ProtectedField protectedField = declaredField.getAnnotation(ProtectedField.class);
                EncryptField encryptField = declaredField.getAnnotation(EncryptField.class);
                if (!ObjectUtil.isNotNull((Object)protectedField) && !ObjectUtil.isNotNull((Object)encryptField)) continue;
                declaredField.setAccessible(true);
                Object fieldData = declaredField.get(parameterObject);
                if (!(fieldData instanceof String)) continue;
                String value = (String)fieldData;
                try {
                    String encrypt = this.encryptAlgorithmApi.encrypt(value);
                    declaredField.set(parameterObject, encrypt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

