/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

class TopologyComparators {
    TopologyComparators() {
    }

    public static List<RedisClusterNode> predefinedSort(Iterable<RedisClusterNode> clusterNodes, Iterable<RedisURI> fixedOrder) {
        Preconditions.checkArgument((clusterNodes != null ? 1 : 0) != 0, (Object)"Cluster nodes must not be null");
        Preconditions.checkArgument((fixedOrder != null ? 1 : 0) != 0, (Object)"Fixed order must not be null");
        final ArrayList fixedOrderList = Lists.newArrayList(fixedOrder);
        List<RedisClusterNode> withOrderSpecification = TopologyComparators.filter(clusterNodes, new Predicate<RedisClusterNode>(){

            public boolean apply(@Nullable RedisClusterNode input) {
                return fixedOrderList.contains(input.getUri());
            }
        });
        List<RedisClusterNode> withoutSpecification = TopologyComparators.filter(clusterNodes, new Predicate<RedisClusterNode>(){

            public boolean apply(@Nullable RedisClusterNode input) {
                return !fixedOrderList.contains(input.getUri());
            }
        });
        Collections.sort(withOrderSpecification, new PredefinedRedisClusterNodeComparator(fixedOrderList));
        Collections.sort(withoutSpecification, new Comparator<RedisClusterNode>(){

            @Override
            public int compare(RedisClusterNode o1, RedisClusterNode o2) {
                return RedisURIComparator.INSTANCE.compare(o1.getUri(), o2.getUri());
            }
        });
        withOrderSpecification.addAll(withoutSpecification);
        return withOrderSpecification;
    }

    private static List<RedisClusterNode> filter(Iterable<RedisClusterNode> clusterNodes, Predicate<RedisClusterNode> predicate) {
        ArrayList list = Lists.newArrayList();
        for (RedisClusterNode clusterNode : clusterNodes) {
            if (!predicate.apply((Object)clusterNode)) continue;
            list.add(clusterNode);
        }
        return list;
    }

    public static boolean isChanged(Partitions o1, Partitions o2) {
        if (o1.size() != o2.size()) {
            return true;
        }
        for (RedisClusterNode base : o2) {
            if (TopologyComparators.essentiallyEqualsTo(base, o1.getPartitionByNodeId(base.getNodeId()))) continue;
            return true;
        }
        return false;
    }

    static boolean essentiallyEqualsTo(RedisClusterNode o1, RedisClusterNode o2) {
        if (o2 == null) {
            return false;
        }
        if (!TopologyComparators.sameFlags(o1, o2, RedisClusterNode.NodeFlag.MASTER)) {
            return false;
        }
        if (!TopologyComparators.sameFlags(o1, o2, RedisClusterNode.NodeFlag.SLAVE)) {
            return false;
        }
        return Sets.newHashSet(o1.getSlots()).equals(Sets.newHashSet(o2.getSlots()));
    }

    private static boolean sameFlags(RedisClusterNode base, RedisClusterNode other, RedisClusterNode.NodeFlag flag) {
        return !(base.getFlags().contains((Object)flag) ? !other.getFlags().contains((Object)flag) : other.getFlags().contains((Object)flag));
    }

    static enum RedisURIComparator implements Comparator<RedisURI>
    {
        INSTANCE;


        @Override
        public int compare(RedisURI o1, RedisURI o2) {
            String h1 = "";
            String h2 = "";
            if (o1 != null) {
                h1 = o1.getHost() + ":" + o1.getPort();
            }
            if (o2 != null) {
                h2 = o2.getHost() + ":" + o2.getPort();
            }
            return h1.compareToIgnoreCase(h2);
        }
    }

    static class PredefinedRedisClusterNodeComparator
    implements Comparator<RedisClusterNode> {
        private final List<RedisURI> fixedOrder;

        public PredefinedRedisClusterNodeComparator(List<RedisURI> fixedOrder) {
            this.fixedOrder = fixedOrder;
        }

        @Override
        public int compare(RedisClusterNode o1, RedisClusterNode o2) {
            int index1 = this.fixedOrder.indexOf(o1.getUri());
            int index2 = this.fixedOrder.indexOf(o2.getUri());
            return PredefinedRedisClusterNodeComparator.compare(index1, index2);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

