/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego.asn1;

import java.io.IOException;
import jcifs.spnego.asn1.ASN1OctetString;
import jcifs.spnego.asn1.ASN1TaggedObject;
import jcifs.spnego.asn1.DERObject;
import jcifs.spnego.asn1.DEROutputStream;
import jcifs.spnego.asn1.DERString;

public class DERUniversalString
extends DERObject
implements DERString {
    byte[] string;
    char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUniversalString.getInstance(obj.getObject());
    }

    public DERUniversalString(byte[] string) {
        this.string = string;
    }

    public String getString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i != this.string.length; ++i) {
            buf.append(this.table[(this.string[i] >>> 4) % 15]);
            buf.append(this.table[this.string[i] & 0xF]);
        }
        return buf.toString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(28, this.getOctets());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)o).getString());
    }
}

