/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego.asn1;

import java.io.IOException;
import jcifs.spnego.asn1.ASN1OctetString;
import jcifs.spnego.asn1.ASN1TaggedObject;
import jcifs.spnego.asn1.DERObject;
import jcifs.spnego.asn1.DEROutputStream;
import jcifs.spnego.asn1.DERString;

public class DERPrintableString
extends DERObject
implements DERString {
    String string;

    public static DERPrintableString getInstance(Object obj) {
        if (obj == null || obj instanceof DERPrintableString) {
            return (DERPrintableString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERPrintableString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERPrintableString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERPrintableString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERPrintableString.getInstance(obj.getObject());
    }

    public DERPrintableString(byte[] string) {
        char[] cs = new char[string.length];
        for (int i = 0; i != cs.length; ++i) {
            cs[i] = (char)(string[i] & 0xFF);
        }
        this.string = new String(cs);
    }

    public DERPrintableString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cs = this.string.toCharArray();
        byte[] bs = new byte[cs.length];
        for (int i = 0; i != cs.length; ++i) {
            bs[i] = (byte)cs[i];
        }
        return bs;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(19, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString s = (DERPrintableString)o;
        return this.getString().equals(s.getString());
    }
}

