/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.smb.SmbComTransaction;

class RapRequest
extends SmbComTransaction {
    private Operation operation;

    RapRequest(Operation operation) {
        this.operation = operation;
        this.command = (byte)37;
        this.subCommand = (byte)38;
        this.name = new String("\\PIPE\\LANMAN");
        this.timeout = 5000;
        this.maxSetupCount = 0;
        this.setupCount = 0;
        this.maxParameterCount = operation.getMaxParameterLength();
        this.maxDataCount = operation.getMaxDataLength();
    }

    int writeParametersWireFormat(byte[] dest, int index) {
        Buffer buffer = new Buffer(dest, index);
        buffer.writeShort(this.operation.getNumber());
        buffer.writeString(this.operation.getParameterDescriptor());
        buffer.writeString(this.operation.getDataDescriptor());
        this.operation.writeRequestParameters(buffer);
        String auxiliaryDataDescriptor = this.operation.getAuxiliaryDataDescriptor();
        if (auxiliaryDataDescriptor != null) {
            buffer.writeString(auxiliaryDataDescriptor);
        }
        return buffer.length();
    }

    int writeDataWireFormat(byte[] dest, int index) {
        String dataDescriptor = this.operation.getDataDescriptor();
        if (dataDescriptor == null) {
            return 0;
        }
        int offset = index + this.calculateSize(dataDescriptor);
        dataDescriptor = this.operation.getAuxiliaryDataDescriptor();
        if (dataDescriptor != null) {
            offset += this.calculateSize(dataDescriptor) * this.operation.getRequestAuxiliaryCount();
        }
        Buffer buffer = new Buffer(dest, index, offset);
        this.operation.writeRequestData(buffer);
        return buffer.length();
    }

    int writeSetupWireFormat(byte[] dest, int index) {
        return 0;
    }

    int readSetupWireFormat(byte[] src, int index, int length) {
        return 0;
    }

    int readParametersWireFormat(byte[] src, int index, int length) {
        return 0;
    }

    int readDataWireFormat(byte[] src, int index, int length) {
        return 0;
    }

    public String toString() {
        return "RapRequest[" + super.toString() + "]";
    }

    private int calculateSize(String dataDescriptor) {
        int size = 0;
        int index = 0;
        int length = dataDescriptor.length();
        block9: while (index < length) {
            int count = 1;
            char c = dataDescriptor.charAt(index++);
            switch (c) {
                case 'W': {
                    String digits;
                    if (index < length && Character.isDigit(dataDescriptor.charAt(index))) {
                        digits = new String();
                        while (index < length && Character.isDigit(c = dataDescriptor.charAt(index))) {
                            digits = digits + c;
                            ++index;
                        }
                        count = Integer.parseInt(digits);
                    }
                    size += 2 * count;
                    continue block9;
                }
                case 'D': {
                    String digits;
                    if (index < length && Character.isDigit(dataDescriptor.charAt(index))) {
                        digits = new String();
                        while (index < length && Character.isDigit(c = dataDescriptor.charAt(index))) {
                            digits = digits + c;
                            ++index;
                        }
                        count = Integer.parseInt(digits);
                    }
                    size += 4 * count;
                    continue block9;
                }
                case 'B': {
                    String digits;
                    if (index < length && Character.isDigit(dataDescriptor.charAt(index))) {
                        digits = new String();
                        while (index < length && Character.isDigit(c = dataDescriptor.charAt(index))) {
                            digits = digits + c;
                            ++index;
                        }
                        count = Integer.parseInt(digits);
                    }
                    size += count;
                    continue block9;
                }
                case 'b': {
                    if (index < length && Character.isDigit(dataDescriptor.charAt(index))) {
                        while (index < length && Character.isDigit(dataDescriptor.charAt(index))) {
                            ++index;
                        }
                    }
                    size += 4;
                }
                case 'O': {
                    size += 4;
                    continue block9;
                }
                case 'z': {
                    size += 4;
                    continue block9;
                }
                case 'N': {
                    size += 2;
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Invalid character: " + dataDescriptor.charAt(index - 1));
        }
        return size;
    }
}

