/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.MalformedURLException;
import jcifs.Config;
import jcifs.rap.Operation;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.RapRequest;
import jcifs.smb.RapResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbFile;

public abstract class Rap {
    protected static final String DEFAULT_TARGET = Config.getProperty((String)"jcifs.smb.client.domain");
    protected SmbFile target;

    public Rap() {
        this(null, null);
    }

    public Rap(String target) {
        this(target, null);
    }

    public Rap(NtlmPasswordAuthentication auth) {
        this(null, auth);
    }

    public Rap(String target, NtlmPasswordAuthentication auth) {
        try {
            if (target == null) {
                target = DEFAULT_TARGET;
            }
            this.target = auth != null ? new SmbFile("smb://", target, auth) : new SmbFile("smb://", target);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid target: " + target);
        }
    }

    public Rap(SmbFile target) {
        if (target == null) {
            throw new NullPointerException("Null target.");
        }
        this.target = target;
    }

    protected int call(Operation operation) throws IOException {
        RapResponse response = new RapResponse(operation);
        this.target.sendTransaction((SmbComTransaction)new RapRequest(operation), (SmbComTransactionResponse)response);
        return response.status;
    }
}

