/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.user;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.rap.group.GroupUsersInfo;

public class NetUserGetGroups
extends Operation {
    private static final int NET_USER_GET_GROUPS = 59;
    public GroupUsersInfo[] groups;
    private String user;
    private GroupUsersInfo infoTemplate;
    private int entryCount;
    private int availableBytes;

    public NetUserGetGroups(String user, GroupUsersInfo infoTemplate) {
        this.user = user;
        this.infoTemplate = infoTemplate;
        this.setNumber(59);
        this.setMaxParameterLength(8);
        this.setParameterDescriptor("zWrLeh");
        this.setDataDescriptor(infoTemplate.getDescriptor());
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeString(this.user.length() > 20 ? this.user.substring(0, 20) : this.user);
        buffer.writeShort(this.infoTemplate.getLevel());
        buffer.writeShort(this.getMaxDataLength());
    }

    public void readResponseParameters(Buffer buffer) {
        this.entryCount = buffer.readShort();
        this.availableBytes = buffer.readShort();
    }

    public void readResponseData(Buffer buffer) {
        this.groups = new GroupUsersInfo[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.groups[i] = (GroupUsersInfo)this.infoTemplate.clone();
            this.groups[i].read(buffer);
        }
    }
}

