/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.user;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.rap.user.UserInfo;

public class NetUserEnum
extends Operation {
    private static final int NET_USER_ENUM = 53;
    public UserInfo[] users;
    private UserInfo infoTemplate;
    private int entryCount;
    private int availableBytes;

    public NetUserEnum(UserInfo infoTemplate) {
        this.infoTemplate = infoTemplate;
        this.setNumber(53);
        this.setMaxParameterLength(8);
        this.setParameterDescriptor("WrLeh");
        this.setDataDescriptor(infoTemplate.getDescriptor());
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeShort(this.infoTemplate.getLevel());
        buffer.writeShort(this.getMaxDataLength());
    }

    public void readResponseParameters(Buffer buffer) {
        this.entryCount = buffer.readShort();
        this.availableBytes = buffer.readShort();
    }

    public void readResponseData(Buffer buffer) {
        this.users = new UserInfo[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.users[i] = (UserInfo)this.infoTemplate.clone();
            this.users[i].read(buffer);
        }
    }
}

