/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.share;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.rap.share.ShareInfo;

public class NetShareEnum
extends Operation {
    private static final int NET_SHARE_ENUM = 0;
    public ShareInfo[] shares;
    private ShareInfo infoTemplate;
    private int entryCount;
    private int availableBytes;

    public NetShareEnum(ShareInfo infoTemplate) {
        this.infoTemplate = infoTemplate;
        this.setNumber(0);
        this.setMaxParameterLength(8);
        this.setParameterDescriptor("WrLeh");
        this.setDataDescriptor(infoTemplate.getDescriptor());
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeShort(this.infoTemplate.getLevel());
        buffer.writeShort(this.getMaxDataLength());
    }

    public void readResponseParameters(Buffer buffer) {
        this.entryCount = buffer.readShort();
        this.availableBytes = buffer.readShort();
    }

    public void readResponseData(Buffer buffer) {
        this.shares = new ShareInfo[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.shares[i] = (ShareInfo)this.infoTemplate.clone();
            this.shares[i].read(buffer);
        }
    }
}

