/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.share;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.rap.share.ConnectionInfo;

public class NetConnectionEnum
extends Operation {
    private static final int NET_CONNECTION_ENUM = 9;
    public ConnectionInfo[] connections;
    private String qualifier;
    private ConnectionInfo infoTemplate;
    private int entryCount;
    private int availableBytes;

    public NetConnectionEnum(String qualifier, ConnectionInfo infoTemplate) {
        this.infoTemplate = infoTemplate;
        this.setNumber(9);
        this.setMaxParameterLength(8);
        this.setParameterDescriptor("zWrLeh");
        this.setDataDescriptor(infoTemplate.getDescriptor());
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeString(this.qualifier.length() > 20 ? this.qualifier.substring(0, 20) : this.qualifier);
        buffer.writeShort(this.infoTemplate.getLevel());
        buffer.writeShort(this.getMaxDataLength());
    }

    public void readResponseParameters(Buffer buffer) {
        this.entryCount = buffer.readShort();
        this.availableBytes = buffer.readShort();
    }

    public void readResponseData(Buffer buffer) {
        this.connections = new ConnectionInfo[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.connections[i] = (ConnectionInfo)this.infoTemplate.clone();
            this.connections[i].read(buffer);
        }
    }
}

