/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.server;

import java.io.IOException;
import java.util.ArrayList;
import jcifs.rap.LevelFactory;
import jcifs.rap.server.NetServerDiskEnum;
import jcifs.rap.server.NetServerEnum2;
import jcifs.rap.server.NetServerEnum3;
import jcifs.rap.server.NetServerGetInfo;
import jcifs.rap.server.NetServerSetInfo;
import jcifs.rap.server.ServerConstants;
import jcifs.rap.server.ServerInfo;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.Rap;
import jcifs.smb.RapException;
import jcifs.smb.SmbFile;

public class ServerManagement
extends Rap
implements ServerConstants {
    static /* synthetic */ Class class$jcifs$rap$server$ServerInfo;

    public ServerManagement() {
        super(null, null);
    }

    public ServerManagement(String target) {
        super(target, null);
    }

    public ServerManagement(NtlmPasswordAuthentication auth) {
        super(null, auth);
    }

    public ServerManagement(String target, NtlmPasswordAuthentication auth) {
        super(target, auth);
    }

    public ServerManagement(SmbFile target) {
        super(target);
    }

    public ServerInfo[] netServerEnum(int level, int serverType, String domain) throws IOException {
        ServerInfo infoTemplate = (ServerInfo)LevelFactory.createInformationLevel(class$jcifs$rap$server$ServerInfo == null ? (class$jcifs$rap$server$ServerInfo = ServerManagement.class$("jcifs.rap.server.ServerInfo")) : class$jcifs$rap$server$ServerInfo, level);
        NetServerEnum2 operation = new NetServerEnum2(infoTemplate, serverType, domain);
        int result = this.call(operation);
        if (result == 0) {
            return operation.servers;
        }
        if (result != 234) {
            throw new RapException(result);
        }
        int length = operation.servers.length;
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>(length);
        for (int i = 0; i < length; ++i) {
            servers.add(operation.servers[i]);
        }
        do {
            int i;
            String followUpName;
            if ((result = this.call(operation = new NetServerEnum3(infoTemplate, serverType, domain, followUpName = operation.servers[length - 1].name))) != 234 && result != 0) continue;
            length = operation.servers.length;
            servers.ensureCapacity(servers.size() + length);
            int n = i = followUpName.equals(operation.servers[0].name) ? 1 : 0;
            while (i < length) {
                servers.add(operation.servers[i]);
                ++i;
            }
        } while (result == 234);
        if (result != 0) {
            throw new RapException(result);
        }
        return servers.toArray(new ServerInfo[servers.size()]);
    }

    public ServerInfo netServerGetInfo(int level) throws IOException {
        ServerInfo info = (ServerInfo)LevelFactory.createInformationLevel(class$jcifs$rap$server$ServerInfo == null ? (class$jcifs$rap$server$ServerInfo = ServerManagement.class$("jcifs.rap.server.ServerInfo")) : class$jcifs$rap$server$ServerInfo, level);
        NetServerGetInfo operation = new NetServerGetInfo(info);
        int result = this.call(operation);
        if (result != 0) {
            throw new RapException(result);
        }
        return info;
    }

    public void netServerSetInfo(ServerInfo info) throws IOException {
        int result = this.call(new NetServerSetInfo(info));
        if (result != 0) {
            throw new RapException(result);
        }
    }

    public String[] netServerDiskEnum() throws IOException {
        NetServerDiskEnum operation = new NetServerDiskEnum();
        int result = this.call(operation);
        if (result != 0) {
            throw new RapException(result);
        }
        return operation.disks;
    }

    public String netGetDcName(String domain) throws IOException {
        ServerInfo[] servers;
        if (domain == null) {
            domain = DEFAULT_TARGET;
        }
        return (servers = this.netServerEnum(0, 8, domain)) == null || servers.length == 0 ? null : servers[0].name;
    }

    public String netGetAnyDcName(String domain) throws IOException {
        ServerInfo[] servers;
        if (domain == null) {
            domain = DEFAULT_TARGET;
        }
        return (servers = this.netServerEnum(0, 24, domain)) == null || servers.length == 0 ? null : servers[0].name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

