/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.group;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.rap.group.GroupUsersInfo;

public class NetGroupGetUsers
extends Operation {
    private static final int NET_GROUP_GET_USERS = 52;
    public GroupUsersInfo[] users;
    private String group;
    private GroupUsersInfo infoTemplate;
    private int entryCount;
    private int availableBytes;

    public NetGroupGetUsers(String group, GroupUsersInfo infoTemplate) {
        this.group = group;
        this.infoTemplate = infoTemplate;
        this.setNumber(52);
        this.setMaxParameterLength(8);
        this.setParameterDescriptor("zWrLeh");
        this.setDataDescriptor(infoTemplate.getDescriptor());
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeString(this.group.length() > 20 ? this.group.substring(0, 20) : this.group);
        buffer.writeShort(this.infoTemplate.getLevel());
        buffer.writeShort(this.getMaxDataLength());
    }

    public void readResponseParameters(Buffer buffer) {
        this.entryCount = buffer.readShort();
        this.availableBytes = buffer.readShort();
    }

    public void readResponseData(Buffer buffer) {
        this.users = new GroupUsersInfo[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.users[i] = (GroupUsersInfo)this.infoTemplate.clone();
            this.users[i].read(buffer);
        }
    }
}

