/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap;

import java.io.UnsupportedEncodingException;
import jcifs.Config;

public class Buffer {
    public static final String ENCODING = Config.getProperty((String)"jcifs.smb.client.codepage", (String)Config.getProperty((String)"jcifs.encoding", (String)System.getProperty("file.encoding")));
    public byte[] buffer;
    public int index;
    public int offset;
    public int start;
    private int base;

    public Buffer(byte[] buffer, int index) {
        this(buffer, index, -1);
    }

    public Buffer(byte[] buffer, int index, int offset) {
        this.buffer = buffer;
        this.index = index;
        this.offset = offset;
        this.start = index;
        this.base = offset;
    }

    public int length() {
        return Math.max(this.index, this.offset) - this.start;
    }

    public void pad(int count) {
        for (int i = 0; i < count; ++i) {
            this.buffer[this.index++] = 0;
        }
    }

    public void skip(int count) {
        this.index += count;
    }

    public int readShort() {
        return (this.buffer[this.index++] & 0xFF) + ((this.buffer[this.index++] & 0xFF) << 8);
    }

    public void writeShort(long value) {
        this.buffer[this.index++] = (byte)((int)value & 0xFF);
        this.buffer[this.index++] = (byte)((int)(value >>> 8) & 0xFF);
    }

    public int readLong() {
        return (this.buffer[this.index++] & 0xFF) + ((this.buffer[this.index++] & 0xFF) << 8) + ((this.buffer[this.index++] & 0xFF) << 16) + ((this.buffer[this.index++] & 0xFF) << 24);
    }

    public void writeLong(long value) {
        this.buffer[this.index++] = (byte)((int)value & 0xFF);
        this.buffer[this.index++] = (byte)((int)(value >>> 8) & 0xFF);
        this.buffer[this.index++] = (byte)((int)(value >>> 16) & 0xFF);
        this.buffer[this.index++] = (byte)((int)(value >>> 24) & 0xFF);
    }

    public String readString() {
        return this.readString(Integer.MAX_VALUE);
    }

    public String readString(int maxLength) {
        int length = 0;
        while (this.buffer[this.index + length] != 0) {
            if (length++ <= maxLength) continue;
            throw new IndexOutOfBoundsException();
        }
        try {
            String string = new String(this.buffer, this.index, length, ENCODING);
            return string;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Encoding \"" + ENCODING + "\" not supported.");
        }
        finally {
            this.index += length + 1;
        }
    }

    public void writeString(String string) {
        if (string == null) {
            string = "";
        }
        try {
            byte[] bytes = string.getBytes(ENCODING);
            System.arraycopy(bytes, 0, this.buffer, this.index, bytes.length);
            this.index += bytes.length;
            this.buffer[this.index++] = 0;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Encoding \"" + ENCODING + "\" not supported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFixedString(int length) {
        int start = this.index;
        try {
            String string = this.readString(length);
            return string;
        }
        finally {
            this.index = start + length + 1;
        }
    }

    public void writeFixedString(String string, int length) {
        if (string == null) {
            string = "";
        }
        if (string.length() > length) {
            string = string.substring(0, length);
        }
        int pos = this.index;
        this.writeString(string);
        pos += length + 1;
        while (this.index < pos) {
            this.buffer[this.index++] = 0;
        }
    }

    public void writeFreeString(String string) {
        if (string == null) {
            string = "";
        }
        this.writeLong(this.offset - this.base);
        try {
            byte[] bytes = string.getBytes(ENCODING);
            System.arraycopy(bytes, 0, this.buffer, this.offset, bytes.length);
            this.offset += bytes.length;
            this.buffer[this.offset++] = 0;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Encoding \"" + ENCODING + "\" not supported.");
        }
    }

    public String readFreeString() {
        int pointer = this.readLong() & 0xFFFF;
        if (pointer == 0) {
            return null;
        }
        pointer += this.base;
        int length = 0;
        while (this.buffer[pointer + length] != 0) {
            ++length;
        }
        try {
            return new String(this.buffer, pointer, length, ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Encoding \"" + ENCODING + "\" not supported.");
        }
    }

    public void writeDataBuffer(byte[] data) {
        this.writeDataBuffer(data, 0, data.length);
    }

    public void writeDataBuffer(byte[] data, int i, int length) {
        if (data == null || length == 0) {
            this.writeLong(0L);
        } else {
            this.writeLong(this.offset - this.base);
            System.arraycopy(data, i, this.buffer, this.offset, length);
            this.offset += length;
        }
    }

    public byte[] readDataBuffer(int length) {
        byte[] data = new byte[length];
        this.readDataBuffer(data, 0, length);
        return data;
    }

    public void readDataBuffer(byte[] data) {
        this.readDataBuffer(data, 0, data.length);
    }

    public void readDataBuffer(byte[] data, int i, int length) {
        int pointer = this.readLong() & 0xFFFF;
        if (pointer == 0) {
            return;
        }
        System.arraycopy(this.buffer, pointer += this.base, data, i, length);
    }
}

