/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.resource.Representation;
import org.restlet.resource.WriterRepresentation;

public final class ByteUtils {
    private static final int NIO_TIMEOUT = 60000;

    public static long exhaust(InputStream input) throws IOException {
        long result = -1L;
        if (input != null) {
            byte[] buf = new byte[4096];
            int read = input.read(buf);
            long l = result = read == -1 ? -1L : 0L;
            while (read != -1) {
                result += (long)read;
                read = input.read(buf);
            }
        }
        return result;
    }

    public static ReadableByteChannel getChannel(InputStream inputStream) {
        return inputStream != null ? Channels.newChannel(inputStream) : null;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(final Representation representation) throws IOException {
        final Pipe pipe = Pipe.open();
        Application application = Application.getCurrent();
        application.getTaskService().execute(new Runnable(){

            public void run() {
                try {
                    Pipe.SinkChannel wbc = pipe.sink();
                    representation.write(wbc);
                    wbc.close();
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.FINE, "Error while writing to the piped channel.", ioe);
                }
            }
        });
        return pipe.source();
    }

    public static Reader getReader(InputStream stream, CharacterSet characterSet) throws UnsupportedEncodingException {
        if (characterSet != null) {
            return new InputStreamReader(stream, characterSet.getName());
        }
        return new InputStreamReader(stream);
    }

    public static Reader getReader(final WriterRepresentation representation) throws IOException {
        final PipedWriter pipedWriter = new PipedWriter();
        PipedReader pipedReader = new PipedReader(pipedWriter);
        Application application = Application.getCurrent();
        application.getTaskService().execute(new Runnable(){

            public void run() {
                try {
                    representation.write(pipedWriter);
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.FINE, "Error while writing to the piped reader.", ioe);
                }
            }
        });
        return pipedReader;
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) {
        NbChannelInputStream result = null;
        if (readableChannel != null) {
            result = new NbChannelInputStream(readableChannel);
        }
        return result;
    }

    public static InputStream getStream(Reader reader, CharacterSet characterSet) {
        return new ReaderInputStream(reader, characterSet);
    }

    public static InputStream getStream(final Representation representation) {
        if (representation == null) {
            return null;
        }
        final PipeStream pipe = new PipeStream();
        Application application = Application.getCurrent();
        application.getTaskService().execute(new Runnable(){

            public void run() {
                try {
                    OutputStream os = pipe.getOutputStream();
                    representation.write(os);
                    os.write(-1);
                    os.close();
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.FINE, "Error while writing to the piped input stream.", ioe);
                }
            }
        });
        return pipe.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream getStream(WritableByteChannel writableChannel) {
        OutputStream result = null;
        if (writableChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)writableChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                result = selectableChannel.isBlocking() ? Channels.newOutputStream(writableChannel) : new NbChannelOutputStream(writableChannel);
            }
        } else {
            result = new NbChannelOutputStream(writableChannel);
        }
        return result;
    }

    public static OutputStream getStream(Writer writer) {
        return new WriterOutputStream(writer);
    }

    private static void release(Selector selector, SelectionKey selectionKey) throws IOException {
        if (selectionKey != null) {
            selectionKey.cancel();
            if (selector != null) {
                selector.selectNow();
                SelectorFactory.returnSelector(selector);
            }
        }
    }

    public static String toString(InputStream inputStream) {
        return ByteUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, CharacterSet characterSet) {
        String result = null;
        if (inputStream != null) {
            try {
                result = characterSet != null ? ByteUtils.toString(new InputStreamReader(inputStream, characterSet.getName())) : ByteUtils.toString(new InputStreamReader(inputStream));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toString(Reader reader) {
        String result = null;
        if (reader != null) {
            try {
                StringBuilder sb = new StringBuilder();
                BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
                char[] buffer = new char[8192];
                int charsRead = br.read(buffer);
                while (charsRead != -1) {
                    sb.append(buffer, 0, charsRead);
                    charsRead = br.read(buffer);
                }
                br.close();
                result = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForState(SelectableChannel selectableChannel, int operations) throws IOException {
        if (selectableChannel != null) {
            Selector selector = null;
            SelectionKey selectionKey = null;
            int selected = 0;
            try {
                selector = SelectorFactory.getSelector();
                while (selected == 0) {
                    selectionKey = selectableChannel.register(selector, operations);
                    selected = selector.select(60000L);
                }
            }
            finally {
                ByteUtils.release(selector, selectionKey);
            }
        }
    }

    public static void write(FileChannel fileChannel, WritableByteChannel writableChannel) throws IOException {
        long position = 0L;
        long count = fileChannel.size();
        long written = 0L;
        SelectableChannel selectableChannel = null;
        if (writableChannel instanceof SelectableChannel) {
            selectableChannel = (SelectableChannel)((Object)writableChannel);
        }
        while (count > 0L) {
            ByteUtils.waitForState(selectableChannel, 4);
            written = fileChannel.transferTo(position, count, writableChannel);
            position += written;
            count -= written;
        }
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void write(InputStream inputStream, RandomAccessFile randomAccessFile) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            randomAccessFile.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void write(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            ByteUtils.write((InputStream)new NbChannelInputStream(readableChannel), new NbChannelOutputStream(writableChannel));
        }
    }

    public static void write(Reader reader, Writer writer) throws IOException {
        int charsRead;
        char[] buffer = new char[2048];
        while ((charsRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, charsRead);
        }
        reader.close();
    }

    private ByteUtils() {
    }

    private static final class WriterOutputStream
    extends OutputStream {
        private final Writer writer;

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        public void close() throws IOException {
            super.close();
            this.writer.close();
        }

        public void flush() throws IOException {
            super.flush();
            this.writer.flush();
        }

        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }

    private static final class SelectorFactory {
        public static int maxSelectors = 20;
        private static final Stack<Selector> selectors = new Stack();
        public static long timeout = 5000L;

        private SelectorFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final Selector getSelector() {
            Stack<Selector> stack = selectors;
            synchronized (stack) {
                Selector selector = null;
                try {
                    if (selectors.size() != 0) {
                        selector = selectors.pop();
                    }
                }
                catch (EmptyStackException ex) {
                    // empty catch block
                }
                try {
                    for (int attempts = 0; selector == null && attempts < 2; ++attempts) {
                        selectors.wait(timeout);
                        try {
                            if (selectors.size() == 0) continue;
                            selector = selectors.pop();
                            continue;
                        }
                        catch (EmptyStackException ex) {
                            break;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return selector;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final void returnSelector(Selector s) {
            Stack<Selector> stack = selectors;
            synchronized (stack) {
                selectors.push(s);
                if (selectors.size() == 1) {
                    selectors.notify();
                }
            }
        }

        static {
            try {
                for (int i = 0; i < maxSelectors; ++i) {
                    selectors.add(Selector.open());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ReaderInputStream
    extends InputStream {
        private byte[] buffer;
        private final CharacterSet characterSet;
        private int index;
        private final BufferedReader localReader;

        public ReaderInputStream(Reader reader, CharacterSet characterSet) {
            this.localReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.buffer = null;
            this.index = -1;
            this.characterSet = characterSet;
        }

        public int read() throws IOException {
            String line;
            int result = -1;
            if (this.buffer == null && (line = this.localReader.readLine()) != null) {
                this.buffer = line.getBytes(this.characterSet.getName());
                this.index = 0;
            }
            if (this.buffer != null) {
                result = this.buffer[this.index++];
                if (this.index == this.buffer.length) {
                    this.buffer = null;
                }
            }
            return result;
        }
    }

    private static final class PipeStream {
        private static final long QUEUE_TIMEOUT = 5L;
        private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

        public InputStream getInputStream() {
            return new InputStream(){
                private boolean endReached = false;

                public int read() throws IOException {
                    try {
                        if (this.endReached) {
                            return -1;
                        }
                        Integer value = (Integer)PipeStream.this.queue.poll(5L, TimeUnit.SECONDS);
                        if (value == null) {
                            throw new IOException("Timeout while reading from the queue-based input stream");
                        }
                        this.endReached = value == -1;
                        return value;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }

        public OutputStream getOutputStream() {
            return new OutputStream(){

                public void write(int b) throws IOException {
                    try {
                        if (!PipeStream.this.queue.offer(b, 5L, TimeUnit.SECONDS)) {
                            throw new IOException("Timeout while writing to the queue-based output stream");
                        }
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }
    }

    private static final class NbChannelOutputStream
    extends OutputStream {
        private final ByteBuffer bb = ByteBuffer.allocate(8192);
        private final WritableByteChannel channel;
        private final SelectableChannel selectableChannel;
        private SelectionKey selectionKey;
        private Selector selector;

        public NbChannelOutputStream(WritableByteChannel channel) {
            this.selectableChannel = channel instanceof SelectableChannel ? (SelectableChannel)((Object)channel) : null;
            this.channel = channel;
            this.selector = null;
        }

        public void close() throws IOException {
            ByteUtils.release(this.selector, this.selectionKey);
            super.close();
        }

        private void doWrite() throws IOException {
            if (this.channel != null && this.bb != null) {
                try {
                    int attempts = 0;
                    while (this.bb.hasRemaining()) {
                        int bytesWritten = this.channel.write(this.bb);
                        ++attempts;
                        if (bytesWritten < 0) {
                            throw new EOFException("Unexpected negative number of bytes written. End of file detected.");
                        }
                        if (bytesWritten == 0) {
                            if (this.selectableChannel == null) continue;
                            if (this.selector == null) {
                                this.selector = SelectorFactory.getSelector();
                            }
                            if (this.selector == null) {
                                if (attempts <= 2) continue;
                                throw new IOException("Unable to obtain a selector. Selector factory returned null.");
                            }
                            this.selectionKey = this.selectableChannel.register(this.selector, 4);
                            if (this.selector.select(60000L) == 0) {
                                if (attempts <= 2) continue;
                                throw new IOException("Unable to select the channel to write to it. Selection timed out.");
                            }
                            --attempts;
                            continue;
                        }
                        attempts = 0;
                    }
                }
                catch (IOException ioe) {
                    throw new IOException("Unable to write to the non-blocking channel. " + ioe.getLocalizedMessage());
                }
                finally {
                    this.bb.clear();
                }
            } else {
                throw new IOException("Unable to write. Null byte buffer or channel detected.");
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.bb.clear();
            this.bb.put(b, off, len);
            this.bb.flip();
            this.doWrite();
        }

        public void write(int b) throws IOException {
            this.bb.clear();
            this.bb.put((byte)b);
            this.bb.flip();
            this.doWrite();
        }
    }

    private static final class NbChannelInputStream
    extends InputStream {
        private final ByteBuffer bb;
        private final ReadableByteChannel channel;
        private boolean endReached;
        private final SelectableChannel selectableChannel;

        public NbChannelInputStream(ReadableByteChannel channel) {
            this.channel = channel;
            this.selectableChannel = channel instanceof SelectableChannel ? (SelectableChannel)((Object)channel) : null;
            this.bb = ByteBuffer.allocate(8192);
            this.bb.flip();
            this.endReached = false;
        }

        public int read() throws IOException {
            int result = -1;
            if (!this.endReached) {
                if (!this.bb.hasRemaining()) {
                    this.refill();
                }
                if (!this.endReached) {
                    result = this.bb.get() & 0xFF;
                }
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = -1;
            if (!this.endReached) {
                if (!this.bb.hasRemaining() && this.selectableChannel != null) {
                    this.refill();
                }
                if (!this.endReached) {
                    result = Math.min(len, this.bb.remaining());
                    this.bb.get(b, off, result);
                }
            }
            return result;
        }

        private int readChannel() throws IOException {
            int result = 0;
            this.bb.clear();
            result = this.channel.read(this.bb);
            this.bb.flip();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refill() throws IOException {
            Selector selector = null;
            SelectionKey selectionKey = null;
            try {
                int bytesRead = this.readChannel();
                if (bytesRead == 0) {
                    selector = SelectorFactory.getSelector();
                    if (selector != null) {
                        selectionKey = this.selectableChannel.register(selector, 1);
                        selector.select(60000L);
                    }
                    bytesRead = this.readChannel();
                } else if (bytesRead == -1) {
                    this.endReached = true;
                }
            }
            catch (Throwable throwable) {
                ByteUtils.release(selector, selectionKey);
                throw throwable;
            }
            ByteUtils.release(selector, selectionKey);
        }
    }
}

