/*
 * Copyright 2008-2108 amoeba.meidusa.com 
 * 
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.meidusa.venus.client.net;

import java.nio.channels.SocketChannel;

import org.apache.commons.pool.PoolableObjectFactory;

import com.meidusa.venus.client.authenticate.Authenticator;
import com.meidusa.venus.client.authenticate.DummyAuthenticator;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;

/**
 * 
 * @author struct
 *
 */
public class VenusNIOConnectionFactory extends PoolableConnectionFactory implements PoolableObjectFactory {
	private Authenticator<HandshakePacket,AuthenPacket> authenticator = new DummyAuthenticator();
    private MessageHandler<VenusNIOConnection> messageHandler;
    private int outQueueMaxSize = 1;

	public int getOutQueueMaxSize() {
		return outQueueMaxSize;
	}

	public MessageHandler<VenusNIOConnection> getMessageHandler() {
        return messageHandler;
    }

	public void setMessageHandler(MessageHandler<VenusNIOConnection> messageHandler) {
        this.messageHandler = messageHandler;
    }

	public Authenticator<HandshakePacket,AuthenPacket> getAuthenticator() {
		return authenticator;
	}

	public void setAuthenticator(Authenticator authenticator) {
		this.authenticator = authenticator;
	}

		
    @Override
    protected Connection newConnectionInstance(SocketChannel channel, long createStamp) {
    	VenusNIOConnection conn = new VenusNIOConnection(channel, createStamp);
    	conn.setAuthenticator(this.getAuthenticator());
        conn.setMessageHandler(messageHandler);
        conn.setOutQueueMaxSize(outQueueMaxSize);
        return conn;
    }

}
