/*
 * Copyright 2008-2108 amoeba.meidusa.com 
 * 
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.meidusa.venus.client.net;

import java.io.IOException;
import java.net.Socket;

import com.meidusa.venus.io.VenusPacketMetaData;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.venus.poolable.ObjectPool;
import com.meidusa.venus.poolable.PoolableObject;
import com.meidusa.toolkit.net.BIOConnection;
import com.meidusa.toolkit.net.io.FramedInputStream;
import com.meidusa.toolkit.net.io.FramingOutputStream;
import com.meidusa.toolkit.net.io.PacketInputStream;
import com.meidusa.toolkit.net.io.PacketOutputStream;

public class VenusBIOConnection extends BIOConnection implements PoolableObject{
	private static VenusPacketMetaData PACKET_META_DATA = new VenusPacketMetaData();
	private static PingPacket PING_PACKET = new PingPacket();
	private ObjectPool objectPool = null;
	private boolean active = false;
	public VenusBIOConnection(Socket socket, long createStamp) {
		super(socket, createStamp);
	}

	@Override
    protected PacketInputStream createPacketInputStream() {
        return new FramedInputStream(PACKET_META_DATA, true);
    }

    @Override
    protected PacketOutputStream createPacketOutputStream() {
        return new FramingOutputStream(PACKET_META_DATA, true);
    }

	public ObjectPool getObjectPool() {
		return objectPool;
	}

	public boolean isActive() {
		return active;
	}

	public boolean isRemovedFromPool() {
		return this.objectPool == null;
	}

	public void setActive(boolean isactive) {
		this.active = isactive;
	}

	public void setObjectPool(ObjectPool pool) {
		this.objectPool = pool;
	}

	@Override
	public boolean checkValid() {
		try {
			this.write(PING_PACKET.toByteBuffer().array());
			this.read();
			return true;
		} catch (IOException e) {
			try {
				this.close();
			} catch (Exception e1) {
			}
		}
		return false;
	}

}
