package com.meidusa.venus.backend;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.meidusa.venus.io.packet.PacketConstant;

public class VenusStatus {
	private static final Logger logger = LoggerFactory.getLogger(ShutdownListener.class);
	private final static String PS_OLD_GEN = "PS Old Gen";
	private static long OOMCount = 0;
	private static VenusStatus instance = new VenusStatus();
	public static VenusStatus getInstance(){
		return instance;
	}
	private static ShutdownListener listener = new ShutdownListener();
    static {
        Runtime.getRuntime().addShutdownHook(listener);
        new Thread(){
        	{
        		this.setDaemon(true);
        		this.setName("VM-OOM-Checker");
        	}
        	public void run(){
        		while(true){
        			List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        			for(MemoryPoolMXBean bean : list){
        				if(StringUtils.equalsIgnoreCase(bean.getName(), PS_OLD_GEN)){
        					MemoryUsage usage = bean.getUsage();
        					
        					double freeRate =((double)(usage.getMax() - usage.getUsed())/(double)usage.getMax());
        					if( freeRate <= 1.0E-7){
        						OOMCount ++;
        						if(OOMCount>10){
        							if(VenusStatus.getInstance().getStatus() == PacketConstant.VENUS_STATUS_RUNNING){
        								VenusStatus.getInstance().setStatus(PacketConstant.VENUS_STATUS_OUT_OF_MEMORY );
        							}
        							logger.warn(bean.getName()+":"+usage);
        						}
        	        		}else{
        	        			OOMCount = 0;
        	        			VenusStatus.getInstance().setStatus((byte)((~PacketConstant.VENUS_STATUS_OUT_OF_MEMORY & VenusStatus.getInstance().getStatus()) & 0xff) );
        	        		}
        				}
        			}
	        		try {
						Thread.sleep(5000);
					} catch (InterruptedException e) {
					}
        		}
        	}
        }.start();
    }

	private VenusStatus(){}
	
	private byte status = PacketConstant.VENUS_STATUS_RUNNING;;
	public byte getStatus() {
		return status;
	}

	public void setStatus(byte status) {
		this.status = status;
	}
	
}
