/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.fastbson.exception.SerializeException;
import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.JSONException;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.util.InetAddressUtil;
import com.meidusa.toolkit.util.StringUtil;
import com.meidusa.toolkit.util.TimeUtil;
import com.meidusa.venus.annotations.ExceptionCode;
import com.meidusa.venus.annotations.RemoteException;
import com.meidusa.venus.backend.DefaultEndpointInvocation;
import com.meidusa.venus.backend.EndpointInvocation;
import com.meidusa.venus.backend.RequestInfo;
import com.meidusa.venus.backend.Response;
import com.meidusa.venus.backend.ShutdownListener;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.network.handler.RemotingInvocationListener;
import com.meidusa.venus.backend.profiling.UtilTimerStack;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.backend.services.xml.bean.PerformanceLogger;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.ExceptionLevel;
import com.meidusa.venus.exception.ServiceInvokeException;
import com.meidusa.venus.exception.ServiceNotCallbackException;
import com.meidusa.venus.exception.ServiceVersionNotAllowException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.VenusExceptionLevel;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AbstractServiceRequestPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.venus.io.packet.PongPacket;
import com.meidusa.venus.io.packet.ServiceAPIPacket;
import com.meidusa.venus.io.packet.ServiceHeadPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.VenusStatusRequestPacket;
import com.meidusa.venus.io.packet.VenusStatusResponsePacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.service.monitor.MonitorRuntime;
import com.meidusa.venus.util.ClasspathAnnotationScanner;
import com.meidusa.venus.util.Range;
import com.meidusa.venus.util.ThreadLocalMap;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusLoggerUtil;
import com.meidusa.venus.util.concurrent.DefaultMultiQueueManager;
import com.meidusa.venus.util.concurrent.MultiBlockingQueue;
import com.meidusa.venus.util.concurrent.MultiBlockingQueueExecutor;
import com.meidusa.venus.util.concurrent.MultiQueueManager;
import com.meidusa.venus.util.concurrent.MultiQueueRunnable;
import com.meidusa.venus.util.concurrent.Named;
import com.meidusa.venus.util.concurrent.QueueConfig;
import com.meidusa.venus.util.concurrent.RejectedExecutionHandler;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceInvokeMessageHandler
implements MessageHandler<VenusFrontendConnection, Tuple<Long, byte[]>>,
Initialisable {
    private static final String TIMEOUT = "The server is busy,waiting-timeout for execution";
    static Map<Class<?>, Integer> codeMap;
    private static String ENDPOINT_INVOKED_TIME;
    private static Logger logger;
    private static Logger REPORT_LOGGER;
    private static Logger performanceLogger;
    private ThreadLocal<Executor> threadLocal = new ThreadLocal<Executor>(){

        @Override
        public Executor initialValue() {
            ExecutorService executor = null;
            if (ServiceInvokeMessageHandler.this.executorEnabled && ServiceInvokeMessageHandler.this.maxExecutionThread > 0) {
                int threadLocalExecutionThread = ServiceInvokeMessageHandler.this.maxExecutionThread / Runtime.getRuntime().availableProcessors();
                if (threadLocalExecutionThread == 0) {
                    threadLocalExecutionThread = 1;
                }
                if (ServiceInvokeMessageHandler.this.executorProtected) {
                    DefaultQueueConfigManager manager = new DefaultQueueConfigManager(threadLocalExecutionThread);
                    MultiBlockingQueue wrapper = new MultiBlockingQueue((MultiQueueManager)manager);
                    MultiBlockingQueueExecutor multiBlockingQueueExecutor = new MultiBlockingQueueExecutor(threadLocalExecutionThread, (long)ServiceInvokeMessageHandler.this.threadLiveTime, TimeUnit.MINUTES, (BlockingQueue)wrapper, (RejectedExecutionHandler)new MultiBlockingQueueExecutor.CallerRunsPolicy());
                    manager.setExecutor(multiBlockingQueueExecutor);
                    manager.init();
                    executor = multiBlockingQueueExecutor;
                } else {
                    executor = Executors.newFixedThreadPool(threadLocalExecutionThread);
                }
            }
            return executor;
        }
    };
    private static ShutdownListener listener;
    private int maxExecutionThread;
    private int threadLiveTime = 30;
    private boolean executorEnabled;
    private boolean executorProtected;
    private boolean useThreadLocalExecutor;
    private Executor executor;
    private VenusExceptionFactory venusExceptionFactory;
    @Autowired
    private ServiceManager serviceManager;

    static {
        Map rmap;
        codeMap = new HashMap();
        Map map = ClasspathAnnotationScanner.find(Exception.class, ExceptionCode.class);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                codeMap.put((Class)entry.getKey(), ((ExceptionCode)entry.getValue()).errorCode());
            }
        }
        if ((rmap = ClasspathAnnotationScanner.find(Exception.class, RemoteException.class)) != null) {
            for (Map.Entry entry : rmap.entrySet()) {
                codeMap.put((Class)entry.getKey(), ((RemoteException)entry.getValue()).errorCode());
            }
        }
        ENDPOINT_INVOKED_TIME = "invoked Totle Time: ";
        logger = LoggerFactory.getLogger(ServiceInvokeMessageHandler.class);
        REPORT_LOGGER = LoggerFactory.getLogger((String)"EndpointMonitor");
        performanceLogger = LoggerFactory.getLogger((String)"venus.backend.performance");
        listener = new ShutdownListener();
        Runtime.getRuntime().addShutdownHook(listener);
    }

    public boolean isExecutorEnabled() {
        return this.executorEnabled;
    }

    public void setExecutorEnabled(boolean executorEnabled) {
        this.executorEnabled = executorEnabled;
    }

    public boolean isExecutorProtected() {
        return this.executorProtected;
    }

    public boolean isUseThreadLocalExecutor() {
        return this.useThreadLocalExecutor;
    }

    public void setUseThreadLocalExecutor(boolean useThreadLocalExecutor) {
        this.useThreadLocalExecutor = useThreadLocalExecutor;
    }

    public void setExecutorProtected(boolean executorProtected) {
        this.executorProtected = executorProtected;
    }

    public int getThreadLiveTime() {
        return this.threadLiveTime;
    }

    public void setThreadLiveTime(int threadLiveTime) {
        this.threadLiveTime = threadLiveTime;
    }

    public int getMaxExecutionThread() {
        return this.maxExecutionThread;
    }

    public void setMaxExecutionThread(int maxExecutionThread) {
        this.maxExecutionThread = maxExecutionThread;
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void handle(VenusFrontendConnection conn, Tuple<Long, byte[]> data) {
        long waitTime = TimeUtil.currentTimeMillis() - (Long)data.left;
        byte[] message = (byte[])data.right;
        long received = System.currentTimeMillis();
        int type = AbstractServicePacket.getType((byte[])message);
        VenusRouterPacket routerPacket = null;
        byte serializeType = conn.getSerializeType();
        String sourceIp = conn.getHost();
        if (0x8000001 == type) {
            routerPacket = new VenusRouterPacket();
            routerPacket.original = message;
            routerPacket.init(message);
            type = AbstractServicePacket.getType((byte[])routerPacket.data);
            message = routerPacket.data;
            serializeType = routerPacket.serializeType;
            try {
                sourceIp = InetAddress.getByAddress(InetAddressUtil.unpack((int)routerPacket.srcIP)).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        byte packetSerializeType = serializeType;
        String finalSourceIp = sourceIp;
        switch (type) {
            case 0x1000001: {
                PingPacket ping = new PingPacket();
                ping.init(message);
                PongPacket pong = new PongPacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)ping, (AbstractServicePacket)pong);
                this.postMessageBack((Connection)conn, null, (AbstractServicePacket)ping, (AbstractServicePacket)pong);
                if (!logger.isDebugEnabled()) break;
                logger.debug("receive ping packet from " + conn.getHost() + ":" + conn.getPort());
                break;
            }
            case 0x1000002: {
                break;
            }
            case 0x5000001: {
                VenusStatusRequestPacket sr = new VenusStatusRequestPacket();
                sr.init(message);
                VenusStatusResponsePacket response = new VenusStatusResponsePacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)sr, (AbstractServicePacket)response);
                response.status = listener.getStatus();
                this.postMessageBack((Connection)conn, null, (AbstractServicePacket)sr, (AbstractServicePacket)response);
                break;
            }
            case 0x2000001: {
                SerializeServiceRequestPacket request = null;
                try {
                    class ServiceRunnable
                    extends MultiQueueRunnable {
                        private final /* synthetic */ VenusFrontendConnection val$conn;
                        private final /* synthetic */ EndpointInvocation.ResultType val$resultTypeFinal;
                        private final /* synthetic */ long val$received;
                        private final /* synthetic */ Endpoint val$endpoint;
                        private final /* synthetic */ String val$apiName;
                        private final /* synthetic */ String val$finalSourceIp;
                        private final /* synthetic */ SerializeServiceRequestPacket val$requestPacket;
                        private final /* synthetic */ byte val$packetSerializeType;
                        private final /* synthetic */ VenusRouterPacket val$finalRouterPacket;
                        private final /* synthetic */ AbstractServiceRequestPacket val$requestFinal;
                        private final /* synthetic */ Map val$paramters;
                        private final /* synthetic */ RemotingInvocationListener val$invocationListenerFinal;

                        ServiceRunnable(VenusFrontendConnection venusFrontendConnection, EndpointInvocation.ResultType resultType, long l, Endpoint endpoint, String string, String string2, SerializeServiceRequestPacket serializeServiceRequestPacket, byte by, VenusRouterPacket venusRouterPacket, AbstractServiceRequestPacket abstractServiceRequestPacket, Map map, RemotingInvocationListener remotingInvocationListener) {
                            this.val$conn = venusFrontendConnection;
                            this.val$resultTypeFinal = resultType;
                            this.val$received = l;
                            this.val$endpoint = endpoint;
                            this.val$apiName = string;
                            this.val$finalSourceIp = string2;
                            this.val$requestPacket = serializeServiceRequestPacket;
                            this.val$packetSerializeType = by;
                            this.val$finalRouterPacket = venusRouterPacket;
                            this.val$requestFinal = abstractServiceRequestPacket;
                            this.val$paramters = map;
                            this.val$invocationListenerFinal = remotingInvocationListener;
                        }

                        public void doRun() {
                            long startRunTime = System.currentTimeMillis();
                            Response result = null;
                            if (this.val$conn.isClosed() && this.val$resultTypeFinal == EndpointInvocation.ResultType.RESPONSE) {
                                return;
                            }
                            try {
                                try {
                                    RequestContext context = ServiceInvokeMessageHandler.this.createContext(ServiceInvokeMessageHandler.this.getRequestInfo(this.val$packetSerializeType, this.val$conn, this.val$finalRouterPacket, this.val$requestFinal), (Connection)this.val$conn, this.val$endpoint, this.val$paramters);
                                    ThreadLocalMap.put((Object)"_REQUEST_CONTEXT_", (Object)context);
                                    result = ServiceInvokeMessageHandler.this.handleRequest(context, (Connection)this.val$conn, this.val$endpoint);
                                    if (result.getErrorCode() == 0) {
                                        if (this.val$resultTypeFinal == EndpointInvocation.ResultType.RESPONSE) {
                                            Serializer serializer = SerializerFactory.getSerializer((short)this.val$packetSerializeType);
                                            SerializeServiceResponsePacket response = new SerializeServiceResponsePacket(serializer, this.val$endpoint.getMethod().getGenericReturnType());
                                            AbstractServicePacket.copyHead((AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)response);
                                            response.result = result.getResult();
                                            ServiceInvokeMessageHandler.this.postMessageBack((Connection)this.val$conn, this.val$finalRouterPacket, (AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)response);
                                        } else if (this.val$resultTypeFinal == EndpointInvocation.ResultType.OK) {
                                            OKPacket ok = new OKPacket();
                                            AbstractServicePacket.copyHead((AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)ok);
                                            ServiceInvokeMessageHandler.this.postMessageBack((Connection)this.val$conn, this.val$finalRouterPacket, (AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)ok);
                                        } else if (this.val$resultTypeFinal == EndpointInvocation.ResultType.NOTIFY && this.val$invocationListenerFinal != null && !this.val$invocationListenerFinal.isResponsed()) {
                                            this.val$invocationListenerFinal.onException((Exception)new ServiceNotCallbackException("Server side not call back error"));
                                        }
                                    } else if (this.val$resultTypeFinal == EndpointInvocation.ResultType.RESPONSE || this.val$resultTypeFinal == EndpointInvocation.ResultType.OK) {
                                        ErrorPacket error = new ErrorPacket();
                                        AbstractServicePacket.copyHead((AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)error);
                                        error.errorCode = result.getErrorCode();
                                        error.message = result.getErrorMessage();
                                        Exception throwable = result.getException();
                                        if (throwable != null) {
                                            Serializer serializer = SerializerFactory.getSerializer((short)this.val$packetSerializeType);
                                            Map mpd = Utils.getBeanPropertyDescriptor(throwable.getClass());
                                            HashMap<String, Object> additionalData = new HashMap<String, Object>();
                                            for (Map.Entry entry : mpd.entrySet()) {
                                                additionalData.put((String)entry.getKey(), ((PropertyDescriptor)entry.getValue()).getReadMethod().invoke((Object)throwable, new Object[0]));
                                            }
                                            error.additionalData = serializer.encode(additionalData);
                                        }
                                        ServiceInvokeMessageHandler.this.postMessageBack((Connection)this.val$conn, this.val$finalRouterPacket, (AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)error);
                                    } else if (this.val$resultTypeFinal == EndpointInvocation.ResultType.NOTIFY && this.val$invocationListenerFinal != null && !this.val$invocationListenerFinal.isResponsed()) {
                                        if (result.getException() == null) {
                                            this.val$invocationListenerFinal.onException((Exception)new DefaultVenusException(result.getErrorCode(), result.getErrorMessage()));
                                        } else {
                                            this.val$invocationListenerFinal.onException(result.getException());
                                        }
                                    }
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("receive service request packet from " + this.val$conn.getHost() + ":" + this.val$conn.getPort());
                                        logger.debug("sending response to ip=" + this.val$conn.getHost() + ":" + this.val$conn.getPort() + ",sourceIP=" + this.val$finalSourceIp + ": " + result + " ");
                                    }
                                }
                                catch (Exception e) {
                                    ErrorPacket error;
                                    block110: {
                                        error = new ErrorPacket();
                                        AbstractServicePacket.copyHead((AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)error);
                                        Integer code = codeMap.get(e.getClass());
                                        if (code != null) {
                                            error.errorCode = code;
                                        } else if (e instanceof CodedException) {
                                            CodedException codeEx = (CodedException)e;
                                            error.errorCode = codeEx.getErrorCode();
                                            if (logger.isDebugEnabled()) {
                                                logger.debug("error when invoke", (Throwable)e);
                                            }
                                        } else {
                                            try {
                                                int i;
                                                Method method = e.getClass().getMethod("getErrorCode", new Class[0]);
                                                error.errorCode = i = ((Integer)method.invoke((Object)e, new Object[0])).intValue();
                                                if (logger.isDebugEnabled()) {
                                                    logger.debug("error when invoke", (Throwable)e);
                                                }
                                            }
                                            catch (Exception e1) {
                                                error.errorCode = 18005000;
                                                if (!logger.isWarnEnabled()) break block110;
                                                logger.warn("error when invoke", (Throwable)e);
                                            }
                                        }
                                    }
                                    error.message = e.getMessage();
                                    ServiceInvokeMessageHandler.this.postMessageBack((Connection)this.val$conn, this.val$finalRouterPacket, (AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)error);
                                    long endRunTime = System.currentTimeMillis();
                                    long queuedTime = startRunTime - this.val$received;
                                    long executTime = endRunTime - startRunTime;
                                    MonitorRuntime.getInstance().calculateAverage(this.val$endpoint.getService().getName(), this.val$endpoint.getName(), executTime);
                                    StringBuffer buffer = new StringBuffer();
                                    buffer.append("[").append(queuedTime).append(",").append(executTime).append("]ms api=").append(this.val$apiName).append(", ip=").append(String.valueOf(this.val$conn.getHost()) + ":" + this.val$conn.getPort()).append(", sourceIP=").append(this.val$finalSourceIp).append(", clientID=").append(this.val$requestPacket.clientId).append(", requestID=").append(this.val$requestPacket.clientRequestId);
                                    PerformanceLogger pLevel = this.val$endpoint.getPerformanceLogger();
                                    if (pLevel != null) {
                                        if (pLevel.isPrintParams()) {
                                            buffer.append(", params=\n");
                                            buffer.append(JSON.toJSONString((Object)this.val$requestPacket.parameterMap));
                                        }
                                        if (pLevel.isPrintResult()) {
                                            if (result == null) {
                                                buffer.append(", result=<null>");
                                            } else {
                                                buffer.append(", result=\n");
                                                buffer.append(JSON.toJSONString((Object)result));
                                            }
                                        }
                                        if (queuedTime >= (long)pLevel.getError() || executTime >= (long)pLevel.getError() || queuedTime + executTime >= (long)pLevel.getError()) {
                                            if (performanceLogger.isErrorEnabled()) {
                                                performanceLogger.error(buffer.toString());
                                            }
                                        } else if (queuedTime >= (long)pLevel.getWarn() || executTime >= (long)pLevel.getWarn() || queuedTime + executTime >= (long)pLevel.getWarn()) {
                                            if (performanceLogger.isWarnEnabled()) {
                                                performanceLogger.warn(buffer.toString());
                                            }
                                        } else if (queuedTime >= (long)pLevel.getInfo() || executTime >= (long)pLevel.getInfo() || queuedTime + executTime >= (long)pLevel.getInfo()) {
                                            if (performanceLogger.isInfoEnabled()) {
                                                performanceLogger.info(buffer.toString());
                                            }
                                        } else if (performanceLogger.isDebugEnabled()) {
                                            performanceLogger.debug(buffer.toString());
                                        }
                                    } else if (queuedTime >= 30000L || executTime >= 30000L || queuedTime + executTime >= 30000L) {
                                        if (performanceLogger.isErrorEnabled()) {
                                            performanceLogger.error(buffer.toString());
                                        }
                                    } else if (queuedTime >= 10000L || executTime >= 10000L || queuedTime + executTime >= 10000L) {
                                        if (performanceLogger.isWarnEnabled()) {
                                            performanceLogger.warn(buffer.toString());
                                        }
                                    } else if (queuedTime >= 5000L || executTime >= 5000L || queuedTime + executTime >= 5000L) {
                                        if (performanceLogger.isInfoEnabled()) {
                                            performanceLogger.info(buffer.toString());
                                        }
                                    } else if (performanceLogger.isDebugEnabled()) {
                                        performanceLogger.debug(buffer.toString());
                                    }
                                    ThreadLocalMap.remove((Object)"_REQUEST_CONTEXT_");
                                    return;
                                }
                                catch (Error e) {
                                    ErrorPacket error = new ErrorPacket();
                                    AbstractServicePacket.copyHead((AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)error);
                                    error.errorCode = 18005002;
                                    error.message = e.getMessage();
                                    ServiceInvokeMessageHandler.this.postMessageBack((Connection)this.val$conn, this.val$finalRouterPacket, (AbstractServicePacket)this.val$requestFinal, (AbstractServicePacket)error);
                                    logger.error("error when invoke", (Throwable)e);
                                    long endRunTime = System.currentTimeMillis();
                                    long queuedTime = startRunTime - this.val$received;
                                    long executTime = endRunTime - startRunTime;
                                    MonitorRuntime.getInstance().calculateAverage(this.val$endpoint.getService().getName(), this.val$endpoint.getName(), executTime);
                                    StringBuffer buffer = new StringBuffer();
                                    buffer.append("[").append(queuedTime).append(",").append(executTime).append("]ms api=").append(this.val$apiName).append(", ip=").append(String.valueOf(this.val$conn.getHost()) + ":" + this.val$conn.getPort()).append(", sourceIP=").append(this.val$finalSourceIp).append(", clientID=").append(this.val$requestPacket.clientId).append(", requestID=").append(this.val$requestPacket.clientRequestId);
                                    PerformanceLogger pLevel = this.val$endpoint.getPerformanceLogger();
                                    if (pLevel != null) {
                                        if (pLevel.isPrintParams()) {
                                            buffer.append(", params=\n");
                                            buffer.append(JSON.toJSONString((Object)this.val$requestPacket.parameterMap));
                                        }
                                        if (pLevel.isPrintResult()) {
                                            if (result == null) {
                                                buffer.append(", result=<null>");
                                            } else {
                                                buffer.append(", result=\n");
                                                buffer.append(JSON.toJSONString((Object)result));
                                            }
                                        }
                                        if (queuedTime >= (long)pLevel.getError() || executTime >= (long)pLevel.getError() || queuedTime + executTime >= (long)pLevel.getError()) {
                                            if (performanceLogger.isErrorEnabled()) {
                                                performanceLogger.error(buffer.toString());
                                            }
                                        } else if (queuedTime >= (long)pLevel.getWarn() || executTime >= (long)pLevel.getWarn() || queuedTime + executTime >= (long)pLevel.getWarn()) {
                                            if (performanceLogger.isWarnEnabled()) {
                                                performanceLogger.warn(buffer.toString());
                                            }
                                        } else if (queuedTime >= (long)pLevel.getInfo() || executTime >= (long)pLevel.getInfo() || queuedTime + executTime >= (long)pLevel.getInfo()) {
                                            if (performanceLogger.isInfoEnabled()) {
                                                performanceLogger.info(buffer.toString());
                                            }
                                        } else if (performanceLogger.isDebugEnabled()) {
                                            performanceLogger.debug(buffer.toString());
                                        }
                                    } else if (queuedTime >= 30000L || executTime >= 30000L || queuedTime + executTime >= 30000L) {
                                        if (performanceLogger.isErrorEnabled()) {
                                            performanceLogger.error(buffer.toString());
                                        }
                                    } else if (queuedTime >= 10000L || executTime >= 10000L || queuedTime + executTime >= 10000L) {
                                        if (performanceLogger.isWarnEnabled()) {
                                            performanceLogger.warn(buffer.toString());
                                        }
                                    } else if (queuedTime >= 5000L || executTime >= 5000L || queuedTime + executTime >= 5000L) {
                                        if (performanceLogger.isInfoEnabled()) {
                                            performanceLogger.info(buffer.toString());
                                        }
                                    } else if (performanceLogger.isDebugEnabled()) {
                                        performanceLogger.debug(buffer.toString());
                                    }
                                    ThreadLocalMap.remove((Object)"_REQUEST_CONTEXT_");
                                    return;
                                }
                            }
                            finally {
                                long endRunTime = System.currentTimeMillis();
                                long queuedTime = startRunTime - this.val$received;
                                long executTime = endRunTime - startRunTime;
                                MonitorRuntime.getInstance().calculateAverage(this.val$endpoint.getService().getName(), this.val$endpoint.getName(), executTime);
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("[").append(queuedTime).append(",").append(executTime).append("]ms api=").append(this.val$apiName).append(", ip=").append(String.valueOf(this.val$conn.getHost()) + ":" + this.val$conn.getPort()).append(", sourceIP=").append(this.val$finalSourceIp).append(", clientID=").append(this.val$requestPacket.clientId).append(", requestID=").append(this.val$requestPacket.clientRequestId);
                                PerformanceLogger pLevel = this.val$endpoint.getPerformanceLogger();
                                if (pLevel != null) {
                                    if (pLevel.isPrintParams()) {
                                        buffer.append(", params=\n");
                                        buffer.append(JSON.toJSONString((Object)this.val$requestPacket.parameterMap));
                                    }
                                    if (pLevel.isPrintResult()) {
                                        if (result == null) {
                                            buffer.append(", result=<null>");
                                        } else {
                                            buffer.append(", result=\n");
                                            buffer.append(JSON.toJSONString((Object)result));
                                        }
                                    }
                                    if (queuedTime >= (long)pLevel.getError() || executTime >= (long)pLevel.getError() || queuedTime + executTime >= (long)pLevel.getError()) {
                                        if (performanceLogger.isErrorEnabled()) {
                                            performanceLogger.error(buffer.toString());
                                        }
                                    } else if (queuedTime >= (long)pLevel.getWarn() || executTime >= (long)pLevel.getWarn() || queuedTime + executTime >= (long)pLevel.getWarn()) {
                                        if (performanceLogger.isWarnEnabled()) {
                                            performanceLogger.warn(buffer.toString());
                                        }
                                    } else if (queuedTime >= (long)pLevel.getInfo() || executTime >= (long)pLevel.getInfo() || queuedTime + executTime >= (long)pLevel.getInfo()) {
                                        if (performanceLogger.isInfoEnabled()) {
                                            performanceLogger.info(buffer.toString());
                                        }
                                    } else if (performanceLogger.isDebugEnabled()) {
                                        performanceLogger.debug(buffer.toString());
                                    }
                                } else if (queuedTime >= 30000L || executTime >= 30000L || queuedTime + executTime >= 30000L) {
                                    if (performanceLogger.isErrorEnabled()) {
                                        performanceLogger.error(buffer.toString());
                                    }
                                } else if (queuedTime >= 10000L || executTime >= 10000L || queuedTime + executTime >= 10000L) {
                                    if (performanceLogger.isWarnEnabled()) {
                                        performanceLogger.warn(buffer.toString());
                                    }
                                } else if (queuedTime >= 5000L || executTime >= 5000L || queuedTime + executTime >= 5000L) {
                                    if (performanceLogger.isInfoEnabled()) {
                                        performanceLogger.info(buffer.toString());
                                    }
                                } else if (performanceLogger.isDebugEnabled()) {
                                    performanceLogger.debug(buffer.toString());
                                }
                                ThreadLocalMap.remove((Object)"_REQUEST_CONTEXT_");
                            }
                        }

                        public String getName() {
                            return this.val$apiName;
                        }
                    }
                    ServiceAPIPacket apiPacket = new ServiceAPIPacket();
                    try {
                        ServicePacketBuffer packetBuffer = new ServicePacketBuffer(message);
                        apiPacket.init((AbstractPacketBuffer)packetBuffer);
                        Endpoint ep = this.getServiceManager().getEndpoint(apiPacket.apiName);
                        Serializer serializer = SerializerFactory.getSerializer((short)packetSerializeType);
                        request = new SerializeServiceRequestPacket(serializer, ep.getParameterTypeDict());
                        packetBuffer.setPosition(0);
                        request.init((AbstractPacketBuffer)packetBuffer);
                        ThreadLocalMap.put((Object)"REQUEST_TRACE_ID", (Object)request.traceId);
                        VenusLoggerUtil.logReceive((byte[])request.traceId, (String)request.apiName, (Map)request.parameterMap);
                    }
                    catch (Exception e) {
                        ErrorPacket error = new ErrorPacket();
                        AbstractServicePacket.copyHead((AbstractServicePacket)apiPacket, (AbstractServicePacket)error);
                        if (e instanceof CodedException) {
                            CodedException codeEx = (CodedException)e;
                            error.errorCode = codeEx.getErrorCode();
                        } else {
                            error.errorCode = e instanceof JSONException || e instanceof SerializeException ? 18004000 : 18005000;
                        }
                        error.message = e.getMessage();
                        this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)error);
                        if (e instanceof VenusExceptionLevel) {
                            if (((VenusExceptionLevel)e).getLevel() != null) {
                                this.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), logger, String.valueOf(e.getMessage()) + " client:{clientID=" + apiPacket.clientId + ",ip=" + conn.getHost() + ":" + conn.getPort() + ",sourceIP=" + finalSourceIp + ", apiName=" + apiPacket.apiName + "}", e);
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug(String.valueOf(e.getMessage()) + " [ip=" + conn.getHost() + ":" + conn.getPort() + ",sourceIP=" + finalSourceIp + ", apiName=" + apiPacket.apiName + "]", (Throwable)e);
                        }
                        return;
                    }
                    String apiName = request.apiName;
                    int index = apiName.lastIndexOf(".");
                    String serviceName = request.apiName.substring(0, index);
                    String methodName = request.apiName.substring(index + 1);
                    Endpoint endpoint = this.getServiceManager().getEndpoint(serviceName, methodName, request.parameterMap.keySet().toArray(new String[0]));
                    EndpointInvocation.ResultType resultType = EndpointInvocation.ResultType.RESPONSE;
                    RemotingInvocationListener invocationListener = null;
                    if (endpoint.isVoid()) {
                        resultType = EndpointInvocation.ResultType.OK;
                        if (endpoint.isAsync()) {
                            resultType = EndpointInvocation.ResultType.NONE;
                        }
                        Class<?>[] classArray = endpoint.getMethod().getParameterTypes();
                        int n = classArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> clazz = classArray[n2];
                            if (InvocationListener.class.isAssignableFrom(clazz)) {
                                resultType = EndpointInvocation.ResultType.NOTIFY;
                                break;
                            }
                            ++n2;
                        }
                    }
                    for (Map.Entry entry : request.parameterMap.entrySet()) {
                        if (!(entry.getValue() instanceof ReferenceInvocationListener)) continue;
                        invocationListener = new RemotingInvocationListener(conn, (ReferenceInvocationListener)entry.getValue(), request, routerPacket);
                        request.parameterMap.put((String)entry.getKey(), invocationListener);
                    }
                    ErrorPacket errorPacket = null;
                    if (errorPacket == null) {
                        errorPacket = ServiceInvokeMessageHandler.checkVersion(endpoint, (AbstractServiceRequestPacket)request);
                    }
                    if (errorPacket == null) {
                        errorPacket = ServiceInvokeMessageHandler.checkActive(endpoint, (AbstractServiceRequestPacket)request);
                    }
                    if (errorPacket == null) {
                        errorPacket = ServiceInvokeMessageHandler.checkTimeout(endpoint, (AbstractServiceRequestPacket)request, waitTime);
                    }
                    if (errorPacket != null) {
                        if (resultType == EndpointInvocation.ResultType.NOTIFY) {
                            if (invocationListener != null) {
                                invocationListener.onException((Exception)new ServiceVersionNotAllowException(errorPacket.message));
                            } else {
                                this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)errorPacket);
                            }
                        } else {
                            this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)errorPacket);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("receive service request packet from " + conn.getHost() + ":" + conn.getPort());
                            logger.debug("sending response to ip=" + conn.getHost() + ":" + conn.getPort() + ",sourceIP=" + finalSourceIp + ": " + errorPacket + " ");
                        }
                        return;
                    }
                    Map paramters = request.parameterMap;
                    SerializeServiceRequestPacket requestFinal = request;
                    EndpointInvocation.ResultType resultTypeFinal = resultType;
                    RemotingInvocationListener invocationListenerFinal = invocationListener;
                    SerializeServiceRequestPacket requestPacket = request;
                    VenusRouterPacket finalRouterPacket = routerPacket;
                    if (this.useThreadLocalExecutor) {
                        Executor executor = this.threadLocal.get();
                        if (executor == null) {
                            new ServiceRunnable(conn, resultTypeFinal, received, endpoint, apiName, finalSourceIp, requestPacket, packetSerializeType, finalRouterPacket, (AbstractServiceRequestPacket)requestFinal, paramters, invocationListenerFinal).run();
                            break;
                        }
                        executor.execute((Runnable)((Object)new ServiceRunnable(conn, resultTypeFinal, received, endpoint, apiName, finalSourceIp, requestPacket, packetSerializeType, finalRouterPacket, (AbstractServiceRequestPacket)requestFinal, paramters, invocationListenerFinal)));
                        break;
                    }
                    if (this.executor == null) {
                        new ServiceRunnable(conn, resultTypeFinal, received, endpoint, apiName, finalSourceIp, requestPacket, packetSerializeType, finalRouterPacket, (AbstractServiceRequestPacket)requestFinal, paramters, invocationListenerFinal).run();
                        break;
                    }
                    this.executor.execute((Runnable)((Object)new ServiceRunnable(conn, resultTypeFinal, received, endpoint, apiName, finalSourceIp, requestPacket, packetSerializeType, finalRouterPacket, (AbstractServiceRequestPacket)requestFinal, paramters, invocationListenerFinal)));
                    break;
                }
                catch (Exception e) {
                    ErrorPacket error = new ErrorPacket();
                    AbstractServicePacket.copyHead(request, (AbstractServicePacket)error);
                    error.errorCode = 18005002;
                    error.message = e.getMessage();
                    this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)error);
                    logger.error("error when invoke", (Throwable)e);
                    return;
                }
                catch (Error e) {
                    ErrorPacket error = new ErrorPacket();
                    AbstractServicePacket.copyHead(request, (AbstractServicePacket)error);
                    error.errorCode = 18005002;
                    error.message = e.getMessage();
                    this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)error);
                    logger.error("error when invoke", (Throwable)e);
                    return;
                }
            }
            default: {
                StringBuilder buffer = new StringBuilder("receive unknown packet type=" + type + "  from ");
                buffer.append(String.valueOf(conn.getHost()) + ":" + conn.getPort()).append("\n");
                buffer.append("-------------------------------").append("\n");
                buffer.append(StringUtil.dumpAsHex((byte[])message, (int)message.length)).append("\n");
                buffer.append("-------------------------------").append("\n");
                ServiceHeadPacket head = new ServiceHeadPacket();
                head.init(message);
                ErrorPacket error = new ErrorPacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)head, (AbstractServicePacket)error);
                error.errorCode = 18007001;
                error.message = "receive unknown packet type=" + type + "  from " + conn.getHost() + ":" + conn.getPort();
                this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)head, (AbstractServicePacket)error);
            }
        }
    }

    private void logDependsOnLevel(ExceptionLevel level, Logger specifiedLogger, String msg, Throwable e) {
        switch (level) {
            case DEBUG: {
                specifiedLogger.debug(msg, e);
                break;
            }
            case INFO: {
                specifiedLogger.info(msg, e);
                break;
            }
            case TRACE: {
                specifiedLogger.trace(msg, e);
                break;
            }
            case WARN: {
                specifiedLogger.warn(msg, e);
                break;
            }
            case ERROR: {
                specifiedLogger.error(msg, e);
                break;
            }
        }
    }

    private static ErrorPacket checkTimeout(Endpoint endpoint, AbstractServiceRequestPacket request, long waitTime) {
        if (waitTime > (long)endpoint.getTimeWait()) {
            ErrorPacket error = new ErrorPacket();
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
            error.errorCode = 18005001;
            error.message = TIMEOUT;
            return error;
        }
        return null;
    }

    private static ErrorPacket checkActive(Endpoint endpoint, AbstractServiceRequestPacket request) {
        Service service = endpoint.getService();
        if (!service.isActive() || !endpoint.isActive()) {
            ErrorPacket error = new ErrorPacket();
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
            error.errorCode = 18005006;
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service=").append(endpoint.getService().getName());
            if (!service.isActive()) {
                buffer.append(" is not active");
            }
            if (!endpoint.isActive()) {
                buffer.append(", endpoint=").append(endpoint.getName()).append(" is not active");
            }
            error.message = buffer.toString();
            return error;
        }
        return null;
    }

    private static ErrorPacket checkVersion(Endpoint endpoint, AbstractServiceRequestPacket request) {
        Service service = endpoint.getService();
        Range range = service.getVersionRange();
        if (range == null || range.contains(request.serviceVersion)) {
            return null;
        }
        ErrorPacket error = new ErrorPacket();
        AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
        error.errorCode = 18005007;
        error.message = "Service=" + endpoint.getService().getName() + ",version=" + request.serviceVersion + " not allow";
        return error;
    }

    protected RequestContext createContext(RequestInfo info, Connection conn, Endpoint endpoint, Map<String, Object> paramters) {
        RequestContext context = new RequestContext();
        context.setParameters(paramters);
        context.setEndPointer(endpoint);
        context.setRequestInfo(info);
        return context;
    }

    private Response handleRequest(RequestContext context, Connection conn, Endpoint endpoint) {
        Response response = new Response();
        DefaultEndpointInvocation invocation = new DefaultEndpointInvocation(context, endpoint);
        try {
            try {
                UtilTimerStack.push(ENDPOINT_INVOKED_TIME);
                response.setResult(invocation.invoke());
            }
            catch (Throwable e) {
                if (e instanceof ServiceInvokeException) {
                    e = ((ServiceInvokeException)e).getTargetException();
                }
                if (e instanceof Exception) {
                    response.setException((Exception)e);
                } else {
                    response.setException((Exception)new DefaultVenusException(e.getMessage(), e));
                }
                Integer code = codeMap.get(e.getClass());
                if (code != null) {
                    response.setErrorCode(code);
                    response.setErrorMessage(e.getMessage());
                } else if (e instanceof CodedException) {
                    response.setErrorCode(((CodedException)e).getErrorCode());
                    response.setErrorMessage(((CodedException)e).getMessage());
                } else {
                    int errorCode = 0;
                    if (this.venusExceptionFactory != null) {
                        errorCode = this.venusExceptionFactory.getErrorCode(e.getClass());
                        if (errorCode != 0) {
                            response.setErrorCode(errorCode);
                        } else {
                            response.setErrorCode(18005000);
                        }
                    } else {
                        response.setErrorCode(18005000);
                    }
                    if (e instanceof NullPointerException && e.getMessage() == null) {
                        response.setErrorMessage("Server Side error caused by NullPointerException");
                    } else {
                        response.setErrorMessage(e.getMessage());
                    }
                }
                Service service = endpoint.getService();
                if (e instanceof VenusExceptionLevel) {
                    if (((VenusExceptionLevel)e).getLevel() != null) {
                        this.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), logger, String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                    }
                } else if (e instanceof RuntimeException && !(e instanceof CodedException)) {
                    logger.error(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                } else if (endpoint.isAsync()) {
                    if (logger.isErrorEnabled()) {
                        logger.error(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                }
                UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
            }
        }
        finally {
            UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
        }
        return response;
    }

    private RequestInfo getRequestInfo(byte packetSerializeType, VenusFrontendConnection conn, VenusRouterPacket routerPacket, AbstractServiceRequestPacket packet) {
        RequestInfo info = new RequestInfo();
        if (routerPacket != null) {
            try {
                info.setRemoteIp(InetAddress.getByAddress(InetAddressUtil.unpack((int)routerPacket.srcIP)).getHostName());
            }
            catch (UnknownHostException e) {
                info.setRemoteIp(conn.getHost());
            }
        } else {
            info.setRemoteIp(conn.getHost());
        }
        info.setProtocol(RequestInfo.Protocol.SOCKET);
        info.setClientId(conn.getClientId());
        if (packetSerializeType == 0) {
            info.setAccept("application/json");
        } else if (packetSerializeType != 1 && packetSerializeType == 2) {
            info.setAccept("application/xml");
        }
        return info;
    }

    public void init() throws InitialisationException {
        if (this.executor == null && this.executorEnabled && !this.useThreadLocalExecutor && this.maxExecutionThread > 0) {
            if (this.executorProtected) {
                MultiBlockingQueueExecutor multiBlockingQueueExecutor = null;
                DefaultQueueConfigManager manager = new DefaultQueueConfigManager(this.maxExecutionThread);
                MultiBlockingQueue blockingQueue = new MultiBlockingQueue((MultiQueueManager)manager);
                multiBlockingQueueExecutor = new MultiBlockingQueueExecutor(this.maxExecutionThread, (long)this.threadLiveTime, TimeUnit.MINUTES, (BlockingQueue)blockingQueue, (RejectedExecutionHandler)new MultiBlockingQueueExecutor.CallerRunsPolicy());
                this.executor = multiBlockingQueueExecutor;
                manager.executor = multiBlockingQueueExecutor;
                manager.init();
            } else {
                this.executor = Executors.newFixedThreadPool(this.maxExecutionThread);
            }
        }
    }

    public void postMessageBack(Connection conn, VenusRouterPacket routerPacket, AbstractServicePacket source, AbstractServicePacket result) {
        if (routerPacket == null) {
            conn.write(result.toByteBuffer());
        } else {
            routerPacket.data = result.toByteArray();
            conn.write(routerPacket.toByteBuffer());
        }
    }

    static /* synthetic */ Logger access$5() {
        return REPORT_LOGGER;
    }

    class DefaultQueueConfigManager
    extends DefaultMultiQueueManager {
        final List list = new ArrayList();
        int maxThread;
        private MultiBlockingQueueExecutor executor = null;

        public DefaultQueueConfigManager(int maxThread) {
            this.maxThread = maxThread;
        }

        public void setExecutor(MultiBlockingQueueExecutor executor) {
            this.executor = executor;
        }

        public Tuple<QueueConfig, Queue> newTuple(Named named) {
            Tuple tuple = super.newTuple(named);
            this.list.add(tuple);
            this.adjustMaxActive((Tuple<QueueConfig, Queue>)tuple);
            return tuple;
        }

        public Queue createQueue(QueueConfig config) {
            return new LinkedBlockingQueue(config.getMaxQueue());
        }

        public QueueConfig getConfig(Named named) {
            QueueConfig config = new QueueConfig();
            config.setMaxQueue(10000);
            config.setName(named.getName());
            return config;
        }

        public int getIdleSize() {
            if (this.executor == null) {
                return 0;
            }
            return this.maxThread - this.executor.getRunningSize();
        }

        private void adjustMaxActive(Tuple<QueueConfig, Queue> tuple) {
            int maxActive = 0;
            maxActive = ((QueueConfig)tuple.left).getAverageLatencyTime() <= 10L ? (int)(0.9 * (double)this.maxThread) : (((QueueConfig)tuple.left).getAverageLatencyTime() < 100L ? (int)(0.8 * (double)this.maxThread) : (((QueueConfig)tuple.left).getAverageLatencyTime() <= 1000L ? (int)(0.5 * (double)this.maxThread) + this.getIdleSize() : (((QueueConfig)tuple.left).getAverageLatencyTime() <= 5000L ? (int)(0.2 * (double)this.maxThread) + this.getIdleSize() : (((QueueConfig)tuple.left).getAverageLatencyTime() <= 10000L ? (int)(0.1 * (double)this.maxThread + 0.7 * (double)this.getIdleSize()) : (int)(0.05 * (double)this.maxThread + 0.5 * (double)this.getIdleSize())))));
            if (((QueueConfig)tuple.left).getMaxActive() > 0 && (double)this.getIdleSize() <= 0.05 * (double)this.maxThread && (double)((QueueConfig)tuple.left).getRunningSize() >= 0.9 * (double)((QueueConfig)tuple.left).getMaxActive()) {
                maxActive = (int)((double)maxActive - 0.1 * (double)this.maxThread);
            }
            if (maxActive == 0) {
                maxActive = 1;
            } else if (maxActive >= this.maxThread && (maxActive = (int)(0.9 * (double)this.maxThread)) == 0) {
                maxActive = 1;
            }
            ((QueueConfig)tuple.left).setMaxActive(maxActive);
        }

        public void init() {
            new Thread(){
                {
                    this.setDaemon(true);
                    this.setName("endPoint-Thread-adjust--" + Thread.currentThread().getName());
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    block2: while (true) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException var1_2) {
                            // empty catch block
                        }
                        if (DefaultQueueConfigManager.this.list.size() < 1) continue;
                        temp = new ArrayList<E>();
                        temp.addAll(DefaultQueueConfigManager.this.list);
                        ServiceInvokeMessageHandler.access$5().info("-----" + Thread.currentThread().getName() + ",total=" + DefaultQueueConfigManager.this.maxThread + ",idle=" + DefaultQueueConfigManager.this.getIdleSize() + "----------");
                        queue = new PriorityQueue<QueueConfig>(temp.size(), new Comparator<QueueConfig>(){

                            @Override
                            public int compare(QueueConfig o1, QueueConfig o2) {
                                return (int)(o2.getAverageLatencyTime() - o1.getAverageLatencyTime());
                            }
                        });
                        for (Tuple tuple : temp) {
                            ServiceInvokeMessageHandler.access$5().info("name=" + ((QueueConfig)tuple.left).getName() + ", runningThread=" + ((QueueConfig)tuple.left).getRunningSize() + ", maxThread=" + ((QueueConfig)tuple.left).getMaxActive() + ", averageLatency=" + ((QueueConfig)tuple.left).getAverageLatencyTime() + ", size=" + ((Queue)tuple.right).size());
                            DefaultQueueConfigManager.access$0(DefaultQueueConfigManager.this, tuple);
                            if (((QueueConfig)tuple.left).getRunningSize() <= 0 || ((QueueConfig)tuple.left).getAverageLatencyTime() <= 0L) continue;
                            queue.add((QueueConfig)tuple.left);
                        }
                        if (!((double)DefaultQueueConfigManager.this.getIdleSize() < 0.1 * (double)DefaultQueueConfigManager.this.maxThread)) continue;
                        config = null;
                        targetIdleSize = (int)(0.1 * (double)DefaultQueueConfigManager.this.maxThread);
                        if (targetIdleSize == 0) {
                            targetIdleSize = 1;
                        }
                        while (true) {
                            if (queue.size() > 0 && (config = (QueueConfig)queue.remove()) != null && targetIdleSize > 0) ** break;
                            continue block2;
                            if (config.getRunningSize() <= targetIdleSize) continue;
                            thisDown = targetIdleSize / (queue.size() + 1);
                            config.setMaxActive(config.getRunningSize() - thisDown);
                            targetIdleSize -= thisDown;
                        }
                        break;
                    }
                }
            }.start();
        }

        static /* synthetic */ void access$0(DefaultQueueConfigManager defaultQueueConfigManager, Tuple tuple) {
            defaultQueueConfigManager.adjustMaxActive((Tuple<QueueConfig, Queue>)tuple);
        }
    }
}

