/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.services;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.backend.services.AbstractServiceManager;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.SingletonService;
import com.meidusa.venus.exception.ConvertException;
import com.meidusa.venus.exception.UnknownParameterException;
import com.meidusa.venus.exception.VenusConfigException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SimpleServiceManager
extends AbstractServiceManager
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(SimpleServiceManager.class);
    private List<Object> serviceInstances;

    public void afterPropertiesSet() throws Exception {
        for (Object instance : this.serviceInstances) {
            Service[] loadedServices = this.loadService(instance);
            if (loadedServices == null) continue;
            Service[] serviceArray = loadedServices;
            int n = loadedServices.length;
            int n2 = 0;
            while (n2 < n) {
                Service service = serviceArray[n2];
                this.services.put(service.getName(), service);
                ++n2;
            }
        }
    }

    public List<Object> getServiceInstances() {
        return this.serviceInstances;
    }

    public void setServiceInstances(List<Object> serviceInstances) {
        this.serviceInstances = serviceInstances;
    }

    public Map<String, Service> getServicesAsMap() {
        return this.services;
    }

    protected Service[] loadService(Object instance) throws UnknownParameterException, ConvertException {
        Class[] interfaces = instance.getClass().getInterfaces();
        Class[] types = AnnotationUtil.getAnnotatedClasses((Class[])interfaces, com.meidusa.venus.annotations.Service.class);
        if (types != null && types.length > 0) {
            Service[] services = new Service[types.length];
            int i = 0;
            while (i < types.length) {
                services[i] = this.loadService0(types[i], instance);
                ++i;
            }
            return services;
        }
        return null;
    }

    protected Service loadService0(Class<?> type, Object instance) throws UnknownParameterException, ConvertException {
        SingletonService service = new SingletonService();
        if (logger.isInfoEnabled()) {
            logger.info("Loading From: " + instance.getClass().getCanonicalName());
        }
        if (type == null) {
            throw new VenusConfigException(instance.getClass().getCanonicalName());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Load Type: " + type.getCanonicalName());
        }
        service.setType(type);
        com.meidusa.venus.annotations.Service serviceAnnotation = type.getAnnotation(com.meidusa.venus.annotations.Service.class);
        if (!serviceAnnotation.name().isEmpty()) {
            service.setName(serviceAnnotation.name());
        } else {
            service.setName(type.getCanonicalName());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Use Name: " + service.getName());
        }
        Method[] methods = type.getMethods();
        HashMultimap endpoints = HashMultimap.create();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(com.meidusa.venus.annotations.Endpoint.class)) {
                Endpoint ep = this.loadEndpoint(method);
                ep.setService(service);
                if (logger.isInfoEnabled()) {
                    logger.info("Add Endpoint: " + ep.getService().getName() + "." + ep.getName());
                }
                endpoints.put((Object)ep.getName(), (Object)ep);
            }
            ++n2;
        }
        service.setEndpoints((Multimap<String, Endpoint>)endpoints);
        service.setInstance(instance);
        return service;
    }
}

