/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.ThreadLocalMap;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusLoggerUtil;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingInvocationListener<T>
implements InvocationListener<T> {
    private static Logger logger = LoggerFactory.getLogger(RemotingInvocationListener.class);
    private VenusFrontendConnection conn;
    private ReferenceInvocationListener<T> source;
    private boolean isResponsed = false;
    private SerializeServiceRequestPacket request;
    private VenusRouterPacket routerPacket;

    public boolean isResponsed() {
        return this.isResponsed;
    }

    public RemotingInvocationListener(VenusFrontendConnection conn, ReferenceInvocationListener<T> source, SerializeServiceRequestPacket request, VenusRouterPacket routerPacket) {
        this.conn = conn;
        this.source = source;
        this.request = request;
        this.routerPacket = routerPacket;
    }

    public void callback(T object) {
        Serializer serializer = SerializerFactory.getSerializer((short)this.conn.getSerializeType());
        SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)response);
        response.callbackObject = object;
        response.apiName = this.request.apiName;
        response.identityData = this.source.getIdentityData();
        byte[] traceID = (byte[])ThreadLocalMap.get((Object)"REQUEST_TRACE_ID");
        if (traceID == null) {
            traceID = VenusLoggerUtil.randomUUID();
            ThreadLocalMap.put((Object)"REQUEST_TRACE_ID", (Object)traceID);
        }
        response.traceId = traceID;
        if (this.routerPacket != null) {
            this.routerPacket.data = response.toByteArray();
            this.conn.write(this.routerPacket.toByteBuffer());
        } else {
            this.conn.write(response.toByteBuffer());
        }
        this.isResponsed = true;
    }

    public void onException(Exception e) {
        Serializer serializer = SerializerFactory.getSerializer((short)this.conn.getSerializeType());
        SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)response);
        if (e instanceof CodedException) {
            CodedException codedException = (CodedException)e;
            response.errorCode = codedException.getErrorCode();
        } else {
            response.errorCode = 18005000;
        }
        if (e != null) {
            Map mpd = Utils.getBeanPropertyDescriptor(e.getClass());
            HashMap<String, Object> additionalData = new HashMap<String, Object>();
            for (Map.Entry entry : mpd.entrySet()) {
                try {
                    additionalData.put((String)entry.getKey(), ((PropertyDescriptor)entry.getValue()).getReadMethod().invoke((Object)e, new Object[0]));
                }
                catch (Exception e1) {
                    logger.error("read bean properpty error", (Throwable)e1);
                }
            }
            response.additionalData = serializer.encode(additionalData);
            response.errorMessage = e.getMessage();
        }
        response.identityData = this.source.getIdentityData();
        response.apiName = this.request.apiName;
        byte[] traceID = (byte[])ThreadLocalMap.get((Object)"REQUEST_TRACE_ID");
        if (traceID == null) {
            traceID = VenusLoggerUtil.randomUUID();
            ThreadLocalMap.put((Object)"REQUEST_TRACE_ID", (Object)traceID);
        }
        response.traceId = traceID;
        if (this.routerPacket != null) {
            this.routerPacket.data = response.toByteArray();
            this.conn.write(this.routerPacket.toByteBuffer());
        } else {
            this.conn.write(response.toByteBuffer());
        }
        this.isResponsed = true;
    }
}

