package com.meidusa.venus.extension.xmpp.io.bson;

import java.io.StringReader;

import org.dom4j.Document;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.serializer.ObjectSerializer;
import com.meidusa.venus.extension.xmpp.XMPPPacketReader;

public  class PacketObjectSerializer<T extends Packet> implements
		ObjectSerializer {

	private static ThreadLocal<XMPPPacketReader> xmppReadThreadLocal = new ThreadLocal<XMPPPacketReader>() {
		protected XMPPPacketReader initialValue() {
			return new XMPPPacketReader();
		}
	};

	public Object deserialize(BSONScanner scanner,
			ObjectSerializer[] subSerializer, int i) {
		String id = scanner.readString();
		try {
			XMPPPacketReader reader = xmppReadThreadLocal.get();
			Document doc = reader.read(new StringReader(id));
			
			Packet packet = null;
        	if("iq".equals(doc.getRootElement().getName())){
        		packet = new IQ(doc.getRootElement());
        	}else if("presence".equals(doc.getRootElement().getName())){
        		packet = new Presence(doc.getRootElement());
        	}else if("message".equals(doc.getRootElement().getName())){
        		packet = new Message(doc.getRootElement());
        	}
        	
        	return (T)packet;

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public void serialize(BSONWriter writer, Object value,
			ObjectSerializer[] subSerializer, int i) {
		writer.writeValue(value.toString());
	}

	public Class<?> getSerializedClass() {
		return Packet.class;
	}

	public byte getBsonSuffix() {
		return 0x02;
	}

}
