/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.extension.monitor;

import java.util.concurrent.locks.LockSupport;

public class MilliSecondTimer {
    private static long m_baseTime;
    private static long m_startNanoTime;
    private static boolean m_isWindows;

    static {
        m_isWindows = false;
    }

    public static long currentTimeMillis() {
        if (m_isWindows) {
            if (m_baseTime == 0L) {
                MilliSecondTimer.initialize();
            }
            long elipsed = (long)((double)(System.nanoTime() - m_startNanoTime) / 1000000.0);
            return m_baseTime + elipsed;
        }
        return System.currentTimeMillis();
    }

    public static void initialize() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            long millis;
            m_isWindows = true;
            m_baseTime = System.currentTimeMillis();
            do {
                LockSupport.parkNanos(100000L);
            } while ((millis = System.currentTimeMillis()) == m_baseTime);
            m_baseTime = millis;
            m_startNanoTime = System.nanoTime();
        } else {
            m_baseTime = System.currentTimeMillis();
            m_startNanoTime = System.nanoTime();
        }
    }
}

