/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.extension.athena;

import com.meidusa.venus.extension.athena.AthenaClientTransaction;
import com.meidusa.venus.extension.athena.AthenaMetricReporter;
import com.meidusa.venus.extension.athena.AthenaProblemReporter;
import com.meidusa.venus.extension.athena.AthenaServerTransaction;
import com.meidusa.venus.extension.athena.delegate.AthenaReporterDelegate;
import com.meidusa.venus.extension.athena.delegate.AthenaTransactionDelegate;
import java.io.IOException;
import java.io.InputStream;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public final class AthenaExtensionResolver {
    private static Logger logger = LoggerFactory.getLogger(AthenaExtensionResolver.class);
    private static AthenaExtensionResolver instance = new AthenaExtensionResolver();
    private static ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    private AthenaExtensionResolver() {
    }

    public static AthenaExtensionResolver getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolver() {
        Ini ini = new Ini();
        String athenaExtensionIniLocation = "classpath:/META-INF/venus.extension.athena.ini";
        Resource resource = resourcePatternResolver.getResource(athenaExtensionIniLocation);
        if (resource.exists()) {
            Profile.Section transactionSection;
            Profile.Section problemSection;
            InputStream is = null;
            try {
                is = resource.getInputStream();
                ini.load(is);
            }
            catch (IOException e) {
                logger.error("load athena ini file error", (Throwable)e);
                return;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    logger.warn("resource cannot be close correctly", (Throwable)e);
                }
            }
            Profile.Section metricSection = (Profile.Section)ini.get((Object)"metric");
            if (metricSection != null) {
                String metricReportClassName = (String)metricSection.get((Object)"metric.reporter");
                AthenaMetricReporter metricReporter = (AthenaMetricReporter)this.newInstance(metricReportClassName);
                AthenaReporterDelegate.getDelegate().setMetricReporter(metricReporter);
            }
            if ((problemSection = (Profile.Section)ini.get((Object)"problem")) != null) {
                String problemReportClassName = (String)problemSection.get((Object)"problem.reporter");
                AthenaProblemReporter problemReporter = (AthenaProblemReporter)this.newInstance(problemReportClassName);
                AthenaReporterDelegate.getDelegate().setProblemReporter(problemReporter);
            }
            if ((transactionSection = (Profile.Section)ini.get((Object)"transaction")) != null) {
                String clientTransactionClassName = (String)transactionSection.get((Object)"client.transaction");
                AthenaClientTransaction clientTransaction = (AthenaClientTransaction)this.newInstance(clientTransactionClassName);
                AthenaTransactionDelegate.getDelegate().setClientTransactionReporter(clientTransaction);
            }
            if (transactionSection != null) {
                String serverTransactionClassName = (String)transactionSection.get((Object)"server.transaction");
                AthenaServerTransaction serverTransaction = (AthenaServerTransaction)this.newInstance(serverTransactionClassName);
                AthenaTransactionDelegate.getDelegate().setServerTransactionReporter(serverTransaction);
            }
        }
    }

    private <T> T newInstance(String className) {
        if (className == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error("load class error " + className, (Throwable)e);
            return null;
        }
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.error("instantiate class error " + className, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error("class cannot be access error " + className, (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        AthenaExtensionResolver.getInstance().resolver();
    }
}

