/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLUtil {
    public static final String JBOSS5_VFSZIP = "vfszip";
    public static final String JBOSS5_VFSMEMORY = "vfsmemory";
    public static final String JBOSS5_VFSFILE = "vfsfile";
    private static final Pattern JAR_PATTERN = Pattern.compile("^(jar:|wsjar:|zip:|vfsfile:|code-source:)?(file:)?(.*?)(\\!/|.jar/)(.*)");
    private static final int JAR_FILE_PATH = 3;

    public static URL normalizeToFileProtocol(URL url) {
        String fileName = url.toExternalForm();
        Matcher jarMatcher = JAR_PATTERN.matcher(fileName);
        try {
            if (URLUtil.isJBoss5Url(url)) {
                return new URL("file", null, fileName.substring(fileName.indexOf(":") + 1));
            }
            if (jarMatcher.matches()) {
                String path = jarMatcher.group(3);
                return new URL("file", "", path);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static final boolean verifyUrl(String url) {
        if (url == null) {
            return false;
        }
        if (url.startsWith("https://")) {
            url = "http://" + url.substring(8);
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isJarURL(URL fileUrl) {
        Matcher jarMatcher = JAR_PATTERN.matcher(fileUrl.getPath());
        return jarMatcher.matches();
    }

    public static boolean isJBoss5Url(URL fileUrl) {
        String protocol = fileUrl.getProtocol();
        return JBOSS5_VFSZIP.equals(protocol) || JBOSS5_VFSMEMORY.equals(fileUrl.getProtocol()) || "true".equals(System.getProperty("jboss.vfs.forceVfsJar")) && JBOSS5_VFSFILE.equals(fileUrl.getProtocol());
    }
}

