/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator;

import com.meidusa.venus.validate.AsmVisitorValidatorFactory;
import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;
import com.meidusa.venus.validate.validator.Validator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class VisitorFieldValidator
extends FieldValidatorSupport {
    private static AsmVisitorValidatorFactory factory = new AsmVisitorValidatorFactory();
    private static Map<ClassPolicy, Validator> internalValidatorChainMapping = new HashMap<ClassPolicy, Validator>();
    private String path;
    private String policy;
    private Validator internalValidatorChain = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public Validator getInternalValidatorChain() {
        return this.internalValidatorChain;
    }

    public void setInternalValidatorChain(Validator internalValidatorChain) {
        this.internalValidatorChain = internalValidatorChain;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Set entries = ((Map)object).entrySet();
            for (Map.Entry element : entries) {
                this.validateObject(element.getValue());
            }
        } else if (object instanceof Collection) {
            for (Object element : (Collection)object) {
                this.validateObject(element);
            }
        } else if (object.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                this.validateObject(Array.get(object, i));
            }
        } else {
            this.validateObject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateObject(Object object) throws ValidationException {
        ClassPolicy validatorClassPolicy = new ClassPolicy(object.getClass(), this.policy);
        Validator chain = internalValidatorChainMapping.get(validatorClassPolicy);
        if (chain == null) {
            Map<ClassPolicy, Validator> map = internalValidatorChainMapping;
            synchronized (map) {
                chain = internalValidatorChainMapping.get(validatorClassPolicy);
                if (chain == null) {
                    chain = factory.createAsmVistorValidator(this.policy, object.getClass(), this.getFieldName());
                    internalValidatorChainMapping.put(validatorClassPolicy, chain);
                }
            }
        }
        chain.validate(object);
        if (this.internalValidatorChain != null) {
            this.internalValidatorChain.validate(object);
        }
    }

    public static class ClassPolicy {
        private Class<?> clazz;
        private String policy;

        public ClassPolicy(Class<?> clazz, String policy) {
            this.clazz = clazz;
            this.policy = policy;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String getPolicy() {
            return this.policy;
        }

        public void setPolicy(String policy) {
            this.policy = policy;
        }

        public int hashCode() {
            return new HashCodeBuilder(780293071, -917577685).append((Object)this.policy).append(this.clazz).toHashCode();
        }
    }
}

