/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator.handler;

import com.meidusa.venus.validate.context.ValidationContext;
import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.validator.handler.ErrorMsgHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContextErrorMsgHandler
implements ErrorMsgHandler {
    private static Logger logger = Logger.getLogger(ValidationContext.class);
    public static Locale defaultLocale = Locale.ENGLISH;
    private static ThreadLocal<ContextErrorMsgHandler> context = new ThreadLocal();
    private Locale locale;
    private List<String> validationErrors;
    private Map<String, List<String>> fieldValidationErrors;

    public static ContextErrorMsgHandler getContextErrorMsgHandler() {
        ContextErrorMsgHandler currentContext = context.get();
        if (currentContext == null) {
            currentContext = new ContextErrorMsgHandler();
            context.set(currentContext);
        }
        return currentContext;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void handleValidationError(String message) throws ValidationException {
        logger.error((Object)("Validation error: " + message));
        if (this.validationErrors == null) {
            this.validationErrors = new LinkedList<String>();
        }
        this.validationErrors.add(message);
    }

    @Override
    public void handleValidationFieldError(String propertyName, String message) throws ValidationException {
        List<String> messageList;
        logger.error((Object)("Validation error for " + propertyName + ":" + message));
        if (this.fieldValidationErrors == null) {
            this.fieldValidationErrors = new HashMap<String, List<String>>();
        }
        if ((messageList = this.fieldValidationErrors.get(propertyName)) == null) {
            messageList = new LinkedList<String>();
            messageList.add(message);
            this.fieldValidationErrors.put(propertyName, messageList);
        }
    }

    public List<String> getValidationErrors() {
        return this.validationErrors;
    }

    public Map<String, List<String>> getFieldValidationErrors() {
        return this.fieldValidationErrors;
    }
}

