/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate;

import com.meidusa.venus.validate.ValidatorManager;
import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.chain.factory.ValidatorChainFactory;
import com.meidusa.venus.validate.chain.factory.VenusValidatorChainFactory;
import java.lang.reflect.Method;
import java.util.HashMap;

public class VenusValidatorManager
implements ValidatorManager {
    private ValidatorChainFactory chainFactory;
    private HashMap<Class<?>, HashMap<String, ValidatorChain>> validatorChainMapping;

    public ValidatorChainFactory getChainFactory() {
        return this.chainFactory;
    }

    public void setChainFactory(ValidatorChainFactory chainFactory) {
        this.chainFactory = chainFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatorChain getValidatorChain(Class<?> service, Method method) {
        String methodName = method.getName();
        HashMap<String, ValidatorChain> endpointChains = this.validatorChainMapping.get(service);
        if (endpointChains == null) {
            HashMap<Class<?>, HashMap<String, ValidatorChain>> hashMap = this.validatorChainMapping;
            synchronized (hashMap) {
                endpointChains = this.validatorChainMapping.get(service);
                if (endpointChains == null) {
                    endpointChains = new HashMap();
                    this.validatorChainMapping.put(service, endpointChains);
                }
            }
        }
        ValidatorChain returnChain = null;
        returnChain = endpointChains.get(methodName);
        if (returnChain == null) {
            HashMap<String, ValidatorChain> hashMap = endpointChains;
            synchronized (hashMap) {
                returnChain = endpointChains.get(methodName);
                if (returnChain == null) {
                    returnChain = this.chainFactory.createValidatorChain(service, method);
                    endpointChains.put(methodName, returnChain);
                }
            }
        }
        return returnChain;
    }

    @Override
    public void init() {
        this.validatorChainMapping = new HashMap();
        this.chainFactory = new VenusValidatorChainFactory();
    }
}

