/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.packet.GenericIOPacketBuffer;
import com.meidusa.venus.io.packet.AbstractVenusPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class VenusRouterPacket
extends AbstractVenusPacket {
    public static final int CONNECTION_SEQUENCE_ID = 14;
    public static final int FRONTEND_REQUEST_ID = 22;
    public static final int BACKEND_REQUEST_ID = 30;
    public static final int VENUS_ROUTER_PACKET_DATA_POSITION = 39;
    private static final long serialVersionUID = 1L;
    public transient byte[] original;
    public int srcIP;
    public long frontendConnectionID;
    public long frontendRequestID;
    public long backendRequestID;
    public byte serializeType = (byte)-1;
    public byte[] data;
    public transient long startTime;

    public VenusRouterPacket() {
        this.type = 0x8000001;
    }

    protected void readBody(ServicePacketBuffer buffer) {
        this.srcIP = buffer.readInt();
        this.frontendConnectionID = buffer.readLong();
        this.frontendRequestID = buffer.readLong();
        this.backendRequestID = buffer.readLong();
        this.serializeType = buffer.readByte();
        int position = buffer.getPosition();
        int length = buffer.readInt();
        buffer.setPosition(position);
        this.data = new byte[length];
        buffer.readBytes(this.data);
    }

    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        buffer.writeInt(this.srcIP);
        buffer.writeLong(this.frontendConnectionID);
        buffer.writeLong(this.frontendRequestID);
        buffer.writeLong(this.backendRequestID);
        buffer.writeByte(this.serializeType);
        buffer.writeBytes(this.data);
    }

    public static ByteBuffer toByteBuffer(VenusRouterPacket packet) {
        byte[] result = VenusRouterPacket.toByteArray(packet);
        return AbstractPacketBuffer.toByteBuffer((byte[])result, (int)0, (int)result.length);
    }

    public static byte[] toByteArray(VenusRouterPacket packet) {
        int position = 4;
        byte[] result = new byte[39 + packet.data.length];
        position = GenericIOPacketBuffer.writeShort((byte[])result, (int)position, (short)2);
        position = GenericIOPacketBuffer.writeInt((byte[])result, (int)position, (int)packet.type);
        position = GenericIOPacketBuffer.writeInt((byte[])result, (int)position, (int)packet.srcIP);
        position = GenericIOPacketBuffer.writeLong((byte[])result, (int)position, (long)packet.frontendConnectionID);
        position = GenericIOPacketBuffer.writeLong((byte[])result, (int)position, (long)packet.frontendRequestID);
        position = GenericIOPacketBuffer.writeLong((byte[])result, (int)position, (long)packet.backendRequestID);
        result[position++] = packet.serializeType;
        System.arraycopy(packet.data, 0, result, position, packet.data.length);
        GenericIOPacketBuffer.writeInt((byte[])result, (int)0, (int)result.length);
        return result;
    }

    protected int calculatePacketSize() {
        return 42;
    }

    protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }

    public static long getConnectionSequenceID(byte[] buf) {
        return GenericIOPacketBuffer.readLong((byte[])buf, (int)14);
    }

    public static long getSourceRequestID(byte[] buf) {
        return GenericIOPacketBuffer.readLong((byte[])buf, (int)22);
    }

    public static long getRemoteRequestID(byte[] buf) {
        return GenericIOPacketBuffer.readLong((byte[])buf, (int)30);
    }

    public static byte[] getData(byte[] message) {
        byte[] bts = new byte[message.length - 39];
        System.arraycopy(message, 39, bts, 0, bts.length);
        return bts;
    }
}

