/*
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU General License as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General License for more details. 
 * 	You should have received a copy of the GNU General License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.meidusa.venus.io.packet;

import java.nio.charset.Charset;
import java.util.Random;


public interface PacketConstant {
	/**
	 * venus 汾
	 */
	String VENUS_VERSION = "3.0.2-RELEASE";
	
	int VENUS_CLIENT_ID = Integer.getInteger("venus.client.id",new Random().nextInt(Integer.MAX_VALUE));

	int VENUS_DEFAULT_PORT = 16800;
	
	byte[] EMPTY_TRACE_ID = new byte[16];
	
	String VENUS_CLIENT = "VENUS-JAVA-CLIENT";
	/**
	 * Э汾
	 */
	short PROTOCOL_VERSION = 2;
	
	int PACKET_HEADER_SIZE = 4;
	/**
	 * Эͷ
	 */
    int SERVICE_HEADER_SIZE = 24;
    
    /**
     * Typeݰеʼλ
     */
    int TYPE_POSITION = 6;
    
    /**
     * ͻIDλ
     */
    int CLIENTID_POSITION = 12;
    
    
    /**
     * ϵкλ
     */
    int SEQUENCE_POSITION = 16;
    
    byte[] SERVICE_HEADER_PAD = new byte[SERVICE_HEADER_SIZE];
    
    int PACKET_TYPE_PING 						= 0x01000001;
    int PACKET_TYPE_PONG 						= 0x01000002;
    
    int PACKET_TYPE_SERVICE_REQUEST 			= 0x02000001;
    int PACKET_TYPE_SERVICE_RESPONSE 			= 0x02000002;
    
    int PACKET_TYPE_HANDSHAKE 					= 0x03000001;
    
    int PACKET_TYPE_AUTHEN					 	= 0x03100000;
    
    int PACKET_TYPE_NOTIFY_PUBLISH 				= 0x04000001;
    
    int PACKET_TYPE_NOTIFY_SUBSCRIBE 			= 0x04000002;
    
    int PACKET_TYPE_VENUS_STATUS_REQUEST		= 0x05000001;
    
    int PACKET_TYPE_VENUS_STATUS_RESPONSE		= 0x05000002;
    
    byte VENUS_STATUS_RUNNING					= 0x01;
    byte VENUS_STATUS_SHUTDOWN					= 0x02;
    
    /**
     * ʶ֤
     */
    byte AUTHEN_TYPE_DUMMY			 			= 0x01 << 0;
    
    /**
     * ʶû뷽ʽ֤
     */
    byte AUTHEN_TYPE_PASSWORD 					= 0x01 << 1;
    
    /**
     * ʶPKIʽ֤2.0.0-BETA汾δʵ֣
     */
    byte AUTHEN_TYPE_PKI			 			= 0x01 << 2;
    
   
    
    int PACKET_TYPE_OK							= 0x00000001;
    int PACKET_TYPE_ERROR 						= 0xFFFFFFFF;
    

    Charset PACKET_CHARSET = Charset.forName("UTF8");

    int PACKET_TYPE_ROUTER		= 0x08000001;
    
    byte CONTENT_TYPE_JSON = 0x00;
    byte CONTENT_TYPE_BSON = 0x01;
    byte CONTENT_TYPE_OBJECT = 0x02;
    
    int AUTH_CURRENT_SUPPORT = AUTHEN_TYPE_DUMMY | AUTHEN_TYPE_PASSWORD;
    
    int AUTO_COMPRESS_SIZE = Integer.getInteger("venus.compress.auto", -1);
    
    /**
     * GZIPѹ
     */
    byte CAPABILITY_GZIP = 1 << 4;
    
    
    /**
     * ͻϢ
     */
    int CAPABILITY_LISTENER = 1 << 7;
    
    int CAPABILITIES = CAPABILITY_GZIP;
}
