/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.convert;

import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import com.meidusa.toolkit.common.bean.ReflectionProvider;
import com.meidusa.venus.convert.Converter;
import com.meidusa.venus.exception.ConvertException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.log4j.Logger;

public class CommonsBeanUtilConverter
implements Converter {
    private ReflectionProvider reflectionProvider = PureJavaReflectionProvider.getInstance();
    private static final Logger logger = Logger.getLogger(CommonsBeanUtilConverter.class);

    @Override
    public Object convert(Object value, Type type) throws ConvertException {
        Object object = null;
        try {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (value instanceof Map && !clazz.isPrimitive()) {
                    object = new HashMap();
                    BeanUtils.populate(object, (Map)((Map)value));
                }
                return BeanUtilsBean.getInstance().getConvertUtils().convert(value, clazz);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                if (Map.class.isAssignableFrom(rawType)) {
                    object = new HashMap();
                } else if (List.class.isAssignableFrom(rawType)) {
                    object = new LinkedList();
                } else {
                    if (rawType.isAssignableFrom(value.getClass()) && rawType.isInterface()) {
                        return value;
                    }
                    object = this.reflectionProvider.newInstance(rawType);
                }
                if (value instanceof Map) {
                    BeanUtils.populate(object, (Map)((Map)value));
                } else {
                    BeanUtils.copyProperties(object, (Object)value);
                }
            }
            return object;
        }
        catch (Exception e) {
            throw new ConvertException(value + " can not convert to " + type);
        }
    }

    @Override
    public Object convert(String name, Object value, Type type, Map<String, Object> context) {
        Object bean;
        block13: {
            String beanName = name.split("\\.")[0];
            String propertyName = name.split("\\.")[1];
            if (!context.containsKey(beanName)) {
                Object object = null;
                try {
                    if (type instanceof Class) {
                        Class clazz = (Class)type;
                        if (value instanceof Map && !clazz.isPrimitive()) {
                            object = this.reflectionProvider.newInstance(clazz);
                        }
                    } else if (type instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        object = this.reflectionProvider.newInstance((Class)parameterizedType.getRawType());
                    }
                }
                catch (Exception e) {
                    throw new ConvertException(value + " can not convert to " + type);
                }
                context.put(beanName, object);
            }
            bean = context.get(beanName);
            try {
                BeanUtils.setProperty((Object)bean, (String)propertyName, (Object)value);
            }
            catch (IllegalAccessException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (InvocationTargetException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SecurityException e) {
                if (!logger.isDebugEnabled()) break block13;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }

    @Override
    public Object convert(Object value, Type type, String helper) throws ConvertException {
        return this.convert(value, type);
    }
}

