/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public class QueueConfig {
    private static long RESET_TIME = 30000L;
    private int maxActive;
    private int maxQueue = 200000;
    private String name;
    private AtomicInteger runningSize = new AtomicInteger(0);
    private boolean inWaiting = false;
    private long averageLatencyTime;
    private long executionTimes;
    private long lastResetTime = System.currentTimeMillis();

    public boolean isInWaiting() {
        return this.inWaiting;
    }

    public void setInWaiting(boolean inWaiting) {
        this.inWaiting = inWaiting;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxQueue() {
        return this.maxQueue;
    }

    public void setMaxQueue(int maxQueue) {
        this.maxQueue = maxQueue;
    }

    public int getRunningSize() {
        return this.runningSize.get();
    }

    public int incrementAndGet() {
        return this.runningSize.incrementAndGet();
    }

    public int decrementAndGet() {
        return this.runningSize.decrementAndGet();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getAverageLatencyTime() {
        return this.averageLatencyTime;
    }

    public void addExecutTime(long latencyTime, long currentTime) {
        if (this.executionTimes == Long.MAX_VALUE || currentTime - this.lastResetTime > RESET_TIME) {
            this.reset();
            this.lastResetTime = currentTime;
        }
        this.averageLatencyTime = (this.averageLatencyTime * this.executionTimes + latencyTime) / (this.executionTimes + 1L);
        ++this.executionTimes;
    }

    private void reset() {
        this.executionTimes = 1L;
    }
}

