/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util;

public class UUID {
    private final long mostSigBits;
    private final long leastSigBits;

    public UUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16);
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
    }

    public String toString() {
        return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    public static String toString(byte[] data) {
        int i;
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        assert (data.length == 16);
        for (i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(data[i] & 0xFF);
        }
        return UUID.digits(mostSigBits >> 32, 8) + "-" + UUID.digits(mostSigBits >> 16, 4) + "-" + UUID.digits(mostSigBits, 4) + "-" + UUID.digits(leastSigBits >> 48, 4) + "-" + UUID.digits(leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static UUID fromString(String name) {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    public UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }
}

