package com.meidusa.venus.util.concurrent;

import java.util.concurrent.RejectedExecutionException;

/**
 * A handler for tasks that cannot be executed by a {@link MultiBlockingQueueExecutor}.
 * 
 * @since 1.5
 * @author Doug Lea
 */
public interface RejectedExecutionHandler {

    /**
     * Method that may be invoked by a {@link MultiBlockingQueueExecutor} when
     * {@link MultiBlockingQueueExecutor#execute execute} cannot accept a task. This may occur when no more threads or
     * queue slots are available because their bounds would be exceeded, or upon shutdown of the Executor.
     * 
     * <p>
     * In the absence of other alternatives, the method may throw an unchecked {@link RejectedExecutionException}, which
     * will be propagated to the caller of {@code execute}.
     * 
     * @param r the runnable task requested to be executed
     * @param executor the executor attempting to execute this task
     * @throws RejectedExecutionException if there is no remedy
     */
    void rejectedExecution(Runnable r, MultiBlockingQueueExecutor executor);
}
