/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.poolable;

import com.meidusa.venus.poolable.ObjectPool;
import com.meidusa.venus.poolable.PoolableObject;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableObjectFactoryWapper
implements PoolableObjectFactory {
    private PoolableObjectFactory factory;
    private ObjectPool pool;

    public PoolableObjectFactoryWapper(ObjectPool pool, PoolableObjectFactory factory) {
        this.factory = factory;
        this.pool = pool;
    }

    public void activateObject(Object obj) throws Exception {
        PoolableObject object = (PoolableObject)obj;
        object.setActive(true);
        this.factory.activateObject(obj);
    }

    public void destroyObject(Object obj) throws Exception {
        PoolableObject object = (PoolableObject)obj;
        if (object.getObjectPool() != null) {
            object.setObjectPool(null);
        }
        this.factory.destroyObject(obj);
    }

    public Object makeObject() throws Exception {
        PoolableObject object = (PoolableObject)this.factory.makeObject();
        object.setObjectPool(this.pool);
        return object;
    }

    public void passivateObject(Object obj) throws Exception {
        PoolableObject object = (PoolableObject)obj;
        object.setActive(false);
        this.factory.passivateObject(obj);
    }

    public boolean validateObject(Object obj) {
        return this.factory.validateObject(obj);
    }
}

