/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util;

import com.meidusa.toolkit.common.util.collection.ArrayHashSet;
import com.meidusa.toolkit.plugins.autoconfig.util.FileUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import java.util.ArrayList;

public class PatternSet {
    private String[] includes;
    private String[] excludes;

    public PatternSet() {
        this(new String[0], new String[0]);
    }

    public PatternSet(String includes) {
        this(StringUtil.split(includes), new String[0]);
    }

    public PatternSet(String includes, String excludes) {
        this(StringUtil.split(includes), StringUtil.split(excludes));
    }

    public PatternSet(String[] includes, String[] excludes) {
        this.includes = PatternSet.normalizePatterns(includes);
        this.excludes = PatternSet.normalizePatterns(excludes);
    }

    public PatternSet(PatternSet patterns, PatternSet defaultPatterns) {
        if ((patterns == null || patterns.isEmpty()) && (patterns = defaultPatterns) == null) {
            patterns = new PatternSet();
        }
        this.includes = patterns.includes;
        this.excludes = patterns.excludes;
    }

    private static String[] normalizePatterns(String[] patterns) {
        if (patterns == null) {
            return new String[0];
        }
        ArrayList<String> patternList = new ArrayList<String>(patterns.length);
        int i = 0;
        while (i < patterns.length) {
            String pattern = patterns[i];
            if (pattern != null) {
                pattern = pattern.trim().replace('\\', '/');
                int startIndex = 0;
                int endIndex = pattern.length();
                while (startIndex < pattern.length() && pattern.charAt(startIndex) == '/') {
                    ++startIndex;
                }
                while (endIndex > 0 && pattern.charAt(endIndex - 1) == '/') {
                    --endIndex;
                }
                if (startIndex > 0 || endIndex < pattern.length()) {
                    pattern = pattern.substring(startIndex, endIndex);
                }
                if (pattern.length() > 0) {
                    patternList.add(pattern);
                }
            }
            ++i;
        }
        return patternList.toArray(new String[patternList.size()]);
    }

    public PatternSet addExcludes(String[] addedExcludes) {
        ArrayHashSet excludeSet = new ArrayHashSet();
        int i = 0;
        while (i < this.excludes.length) {
            excludeSet.add(this.excludes[i]);
            ++i;
        }
        i = 0;
        while (i < addedExcludes.length) {
            excludeSet.add(addedExcludes[i]);
            ++i;
        }
        this.excludes = excludeSet.toArray(new String[excludeSet.size()]);
        return this;
    }

    public PatternSet addDefaultExcludes() {
        return this.addExcludes(FileUtil.DEFAULT_EXCLUDES);
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public boolean isEmpty() {
        return this.includes.length == 0 && this.excludes.length == 0;
    }

    public boolean isIncludeAll() {
        if (this.isExcludeAll()) {
            return false;
        }
        return this.includes.length == 1 && "**".equals(this.includes[0]) && this.excludes.length == 0;
    }

    public boolean isExcludeAll() {
        return this.excludes.length == 1 && "**".equals(this.excludes[0]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("includes[");
        int i = 0;
        while (i < this.includes.length) {
            String include = this.includes[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(include);
            ++i;
        }
        buffer.append("]");
        buffer.append(", excludes[");
        i = 0;
        while (i < this.excludes.length) {
            String exclude = this.excludes[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(exclude);
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }
}

