package com.meidusa.toolkit.plugins.autoconfig.util.collection;

import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.i18n.LocaleInfo;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import java.net.URL;

import java.util.Properties;

/**
 * չ<code>Properties</code>, ִ֧<code>Reader</code>жȡunicodeַ
 *
 * 
 */
public class ExtendedProperties extends Properties {
    private static final long   serialVersionUID            = 3258126960071555380L;
    private static final String KEY_VALUE_SEPARATORS        = "= \t\r\n\f";
    private static final String STRICT_KEY_VALUE_SEPARATORS = "=";
    private static final String WHITE_SPACE_CHARS           = " \t\r\n\f";

    /**
     * ָpropertiesļУĬϵıַȡԺֵ
     *
     * @param resource propertiesļ
     *
     * @throws IOException ļʧܻļʽ
     */
    public synchronized void load(URL resource) throws IOException {
        load(resource, null);
    }

    /**
     * ָpropertiesļУָıַȡԺֵ
     *
     * @param resource propertiesļ
     * @param charset ַ
     *
     * @throws IOException ļʧܻļʽ
     */
    public synchronized void load(URL resource, String charset)
            throws IOException {
        charset = getCharset(charset);

        InputStream istream = null;

        try {
            istream = resource.openStream();

            if (!(istream instanceof BufferedInputStream)) {
                istream = new BufferedInputStream(istream, 8192);
            }

            load(new InputStreamReader(istream, charset), resource.toExternalForm());
        } finally {
            if (istream != null) {
                try {
                    istream.close();
                } catch (IOException e) {
                }
            }
        }
    }

    /**
     * ָУĬϵıַȡԺֵ
     *
     * @param istream ַ
     *
     * @throws IOException ļʧܻļʽ
     */
    public synchronized void load(InputStream istream) throws IOException {
        String charset = getCharset(null);

        if (!(istream instanceof BufferedInputStream)) {
            istream = new BufferedInputStream(istream, 8192);
        }

        load(new InputStreamReader(istream, charset), null);
    }

    private String getCharset(String charset) {
        if (charset == null) {
            charset = LocaleInfo.getDefault().getCharset();
        }

        return charset;
    }

    /**
     * ָУĬϵıַȡԺֵ
     *
     * @param reader ַ
     *
     * @throws IOException ļʧܻļʽ
     */
    private synchronized void load(Reader reader, String url)
            throws IOException {
        BufferedReader in         = (reader instanceof BufferedReader) ? (BufferedReader) reader
                                                                       : new BufferedReader(reader);
        int            lineNumber = 0;

        while (true) {
            // ȡһ
            String line = in.readLine();

            lineNumber++;

            if (line == null) {
                return;
            }

            // ȥβĿհ
            line = line.trim();

            if (line.length() > 0) {
                // ԡ\βһеļ
                char firstChar = line.charAt(0);

                if ((firstChar != '#') && (firstChar != '!')) {
                    while (isContinueLine(line)) {
                        String nextLine = in.readLine();

                        if (nextLine == null) {
                            nextLine = "";
                        }

                        String loppedLine = line.substring(0, line.length() - 1);

                        // ȥϵĿո
                        int startIndex = 0;

                        for (startIndex = 0; startIndex < nextLine.length(); startIndex++) {
                            if (WHITE_SPACE_CHARS.indexOf(nextLine.charAt(startIndex)) == -1) {
                                break;
                            }
                        }

                        nextLine = nextLine.substring(startIndex, nextLine.length());
                        line     = new String(loppedLine + nextLine);
                    }

                    // ҵkeyĿʼ
                    int len      = line.length();
                    int keyStart;

                    for (keyStart = 0; keyStart < len; keyStart++) {
                        if (WHITE_SPACE_CHARS.indexOf(line.charAt(keyStart)) == -1) {
                            break;
                        }
                    }

                    // Կ
                    if (keyStart == len) {
                        continue;
                    }

                    // keyvalueķֽ
                    int separatorIndex;

                    for (separatorIndex = keyStart; separatorIndex < len; separatorIndex++) {
                        char currentChar = line.charAt(separatorIndex);

                        if (currentChar == '\\') {
                            separatorIndex++;
                        } else if (KEY_VALUE_SEPARATORS.indexOf(currentChar) != -1) {
                            break;
                        }
                    }

                    // keyĿհףеĻ
                    int valueIndex;

                    for (valueIndex = separatorIndex; valueIndex < len; valueIndex++) {
                        if (WHITE_SPACE_CHARS.indexOf(line.charAt(valueIndex)) == -1) {
                            break;
                        }
                    }

                    // һǿհ׵key-valueֽ
                    if (valueIndex < len) {
                        if (STRICT_KEY_VALUE_SEPARATORS.indexOf(line.charAt(valueIndex)) != -1) {
                            valueIndex++;
                        }
                    }

                    // ֽĿհ
                    while (valueIndex < len) {
                        if (WHITE_SPACE_CHARS.indexOf(line.charAt(valueIndex)) == -1) {
                            break;
                        }

                        valueIndex++;
                    }

                    String key   = line.substring(keyStart, separatorIndex);
                    String value = (separatorIndex < len) ? line.substring(valueIndex, len)
                                                          : "";

                    // תkeyvalue
                    key   = loadConvert(key, url, lineNumber);
                    value = loadConvert(value, url, lineNumber);

                    put(key, value);
                }
            }
        }
    }

    /**
     * жϸǷһС
     *
     * @param line ָ
     *
     * @return Ǻһģ򷵻<code>true</code>
     */
    private boolean isContinueLine(String line) {
        int slashCount = 0;
        int index      = line.length() - 1;

        while ((index >= 0) && (line.charAt(index--) == '\\')) {
            slashCount++;
        }

        return ((slashCount % 2) == 1);
    }

    /**
     * &#92;uxxxxתunicodeַתԭĸʽ
     *
     * @param str Ҫתַ
     *
     * @return תַ
     */
    private String loadConvert(String str, String url, int lineNumber) {
        char         ch;
        int          len    = str.length();
        StringBuffer buffer = new StringBuffer(len);

        if (StringUtil.isEmpty(url)) {
            url = "<unknown source>";
        }

        for (int x = 0; x < len;) {
            ch = str.charAt(x++);

            if (ch == '\\') {
                ch = str.charAt(x++);

                if (ch == 'u') {
                    // Read the xxxx
                    int value = 0;

                    for (int i = 0; i < 4; i++) {
                        ch = str.charAt(x++);

                        switch (ch) {
                            case '0':
                            case '1':
                            case '2':
                            case '3':
                            case '4':
                            case '5':
                            case '6':
                            case '7':
                            case '8':
                            case '9':
                                value = ((value << 4) + ch) - '0';
                                break;

                            case 'a':
                            case 'b':
                            case 'c':
                            case 'd':
                            case 'e':
                            case 'f':
                                value = ((value << 4) + 10 + ch) - 'a';
                                break;

                            case 'A':
                            case 'B':
                            case 'C':
                            case 'D':
                            case 'E':
                            case 'F':
                                value = ((value << 4) + 10 + ch) - 'A';
                                break;

                            default:
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding at "
                                                                   + url + ", line " + lineNumber);
                        }
                    }

                    buffer.append((char) value);
                } else {
                    if (ch == '\\') {
                        ch = '\\';
                    } else if (ch == 't') {
                        ch = '\t';
                    } else if (ch == 'r') {
                        ch = '\r';
                    } else if (ch == 'n') {
                        ch = '\n';
                    } else if (ch == 'f') {
                        ch = '\f';
                    } else {
                        throw new IllegalArgumentException("Invalid \\" + ch + " at " + url
                                                           + ", line " + lineNumber);
                    }

                    buffer.append(ch);
                }
            } else {
                buffer.append(ch);
            }
        }

        return buffer.toString();
    }
}
