package com.meidusa.toolkit.plugins.autoconfig.util;

import java.io.IOException;
import java.io.PrintWriter;

/**
 * This class prompts the user for a password and attempts to mask input with ""
 */
public class PasswordField {
    /**
     * @param prompt The prompt to display to the user.
     *
     * @return The password as entered by the user.
     */
    public String getPassword(PrintWriter out, String prompt)
            throws IOException {
        // password holder
        String        password      = "";
        MaskingThread maskingthread = new MaskingThread(out, prompt);
        Thread        thread        = new Thread(maskingthread);

        thread.start();

        // block until enter is pressed
        while (true) {
            char c = (char) System.in.read();

            // assume enter pressed, stop masking
            maskingthread.stopMasking();

            if (c == '\r') {
                c = (char) System.in.read();

                if (c == '\n') {
                    break;
                } else {
                    continue;
                }
            } else if (c == '\n') {
                break;
            } else {
                // store the password
                password += c;
            }
        }

        return password;
    }

    /**
     * This class attempts to erase characters echoed to the console.
     */
    class MaskingThread extends Thread {
        private boolean     stop   = false;
        private int         index;
        private PrintWriter out;
        private String      prompt;

        /**
         * @param prompt The prompt displayed to the user
         */
        public MaskingThread(PrintWriter out, String prompt) {
            this.out    = out;
            this.prompt = prompt;
        }

        /**
         * Begin masking until asked to stop.
         */
        public void run() {
            while (!stop) {
                try {
                    // attempt masking at this rate
                    sleep(1);
                } catch (InterruptedException iex) {
                    iex.printStackTrace();
                }

                if (!stop) {
                    out.print("\r" + prompt + " \r" + prompt);
                }

                out.flush();
            }
        }

        /**
         * Instruct the thread to stop masking.
         */
        public void stopMasking() {
            this.stop = true;
        }
    }
}
