package com.meidusa.toolkit.plugins.autoconfig.generator;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Ŀ¼ļcallback
 *
 * 
 */
public class DirectoryCallback implements ConfigGeneratorCallback {
    private final ConfigGenerator generator;
    private File                  destfileBase;
    private InputStream           istream;
    private OutputStream          ostream;

    public DirectoryCallback(ConfigGenerator generator) {
        this.generator = generator;
    }

    public DirectoryCallback(ConfigGenerator generator, File destfileBase) {
        this.generator    = generator;
        this.destfileBase = destfileBase;
    }

    public void nextEntry(ConfigDescriptor descriptor, String template, String dest) {
    	File projectPath = this.generator.configSettings.getProjectPath();
        File templateBase = projectPath == null?descriptor.getBaseFile():projectPath;
        File destfileBase = this.destfileBase;
        
        if (destfileBase == null) {
            destfileBase = projectPath == null?templateBase: projectPath;
        }
        
        File templateFile = new File(templateBase, template);
        File destFile     = new File(destfileBase, dest);

        // destFileĸĿ¼
        File destBase = destFile.getParentFile();

        destBase.mkdirs();

        if (!destBase.isDirectory()) {
            throw new ConfigException("Could not create directory: " + destBase.getAbsolutePath());
        }

        if (!templateFile.exists()) {
            throw new ConfigException("Could not find template file: "
                                      + templateFile.getAbsolutePath() + " for descriptor: "
                                      + descriptor.getURL());
        }

        try {
            istream = new BufferedInputStream(new FileInputStream(templateFile), 8192);
            ostream = new BufferedOutputStream(new FileOutputStream(destFile), 8192);
        } catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }

        generator.getSession().setInputStream(istream);
        generator.getSession().setOutputStream(ostream);
    }

    public void logEntry(ConfigDescriptor descriptor, String logfileName) {
        File templateBase = descriptor.getBaseFile();
        File destfileBase = this.destfileBase;

        if (destfileBase == null) {
            destfileBase =  templateBase;
        }

        File logfile = new File(destfileBase, logfileName);

        // logfileĸĿ¼
        File logbase = logfile.getParentFile();

        logbase.mkdirs();

        if (!logbase.isDirectory()) {
            throw new ConfigException("Could not create directory: " + logbase.getAbsolutePath());
        }

        try {
            ostream = new BufferedOutputStream(new FileOutputStream(logfile), 8192);
        } catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }

        generator.getSession().setOutputStream(ostream);
    }

    public void closeEntry() {
        if (istream != null) {
            try {
                istream.close();
            } catch (IOException e) {
            }

            istream = null;
        }

        if (ostream != null) {
            try {
                ostream.close();
            } catch (IOException e) {
            }

            ostream = null;
        }
    }
}
