/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.factory;

import com.meidusa.toolkit.net.FrontendConnection;
import com.meidusa.toolkit.net.buffer.BufferQueue;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public abstract class FrontendConnectionFactory {
    protected int sendBufferSize = 8;
    protected int receiveBufferSize = 16;
    protected int maxPacketSize = 0x1000000;
    protected int writeQueueCapcity = 16;
    protected long idleTimeout = 28800000L;

    protected abstract FrontendConnection getConnection(SocketChannel var1);

    public FrontendConnection make(SocketChannel channel) throws IOException {
        Socket socket = channel.socket();
        socket.setReceiveBufferSize(this.receiveBufferSize * 1024);
        socket.setSendBufferSize(this.sendBufferSize * 1024);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        FrontendConnection c = this.getConnection(channel);
        c.setMaxPacketSize(this.maxPacketSize);
        c.setWriteQueue(new BufferQueue(this.writeQueueCapcity));
        c.setIdleTimeout(this.idleTimeout);
        return c;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int socketRecvBuffer) {
        this.sendBufferSize = socketRecvBuffer;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int socketSendBuffer) {
        this.receiveBufferSize = socketSendBuffer;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getWriteQueueCapcity() {
        return this.writeQueueCapcity;
    }

    public void setWriteQueueCapcity(int writeQueueCapcity) {
        this.writeQueueCapcity = writeQueueCapcity;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }
}

