/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.net.AuthingableBackendConnection;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.net.GenericHeartbeatDelayed;
import com.meidusa.toolkit.net.factory.BackendConnectionFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBackendConnectionPool<F extends BackendConnectionFactory, V extends BackendConnection>
implements BackendConnectionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleBackendConnectionPool.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final F factory;
    private final int size;
    private final BackendConnection[] items;
    private int activeCount;
    private int idleCount;
    private String name;
    private boolean valid = true;
    private boolean closed = false;
    private GenericHeartbeatDelayed delay = new GenericHeartbeatDelayed(3L, TimeUnit.SECONDS, this);

    @Override
    public String getName() {
        return this.name;
    }

    public SimpleBackendConnectionPool(String name, F factory, int size) {
        this.size = size;
        this.items = new BackendConnection[size];
        this.factory = factory;
        this.name = name;
    }

    @Override
    public BackendConnection borrowObject() throws Exception {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.activeCount >= this.size) {
                StringBuilder s = new StringBuilder();
                s.append("[name=").append(this.name).append(",active=");
                s.append(this.activeCount).append(",size=").append(this.size).append(']');
                LOGGER.error(s.toString());
            }
            BackendConnection[] items = this.items;
            int i = 0;
            int len = items.length;
            while (this.idleCount > 0 && i < len) {
                if (items[i] != null) {
                    BackendConnection conn = items[i];
                    items[i] = null;
                    --this.idleCount;
                    if (!conn.isClosed()) {
                        ++this.activeCount;
                        conn.setActive(true);
                        BackendConnection backendConnection = conn;
                        return backendConnection;
                    }
                }
                ++i;
            }
            ++this.activeCount;
        }
        finally {
            lock.unlock();
        }
        try {
            BackendConnection conn = ((BackendConnectionFactory)this.factory).make();
            conn.setPool(this);
            conn.setActive(true);
            return conn;
        }
        catch (Exception e) {
            lock.lock();
            try {
                --this.activeCount;
            }
            finally {
                lock.unlock();
            }
            throw e;
        }
    }

    @Override
    public void returnObject(BackendConnection c) {
        if (c == null || c.isClosed()) {
            return;
        }
        if (c instanceof AuthingableBackendConnection && !((AuthingableBackendConnection)c).isAuthenticated()) {
            return;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BackendConnection[] items = this.items;
            int i = 0;
            while (i < items.length) {
                if (items[i] == null) {
                    ++this.idleCount;
                    --this.activeCount;
                    items[i] = c;
                    c.setActive(false);
                    return;
                }
                ++i;
            }
        }
        finally {
            lock.unlock();
        }
        c.close();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        HeartbeatManager.removeHeartbeat((HeartbeatDelayed)this.delay);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            block9: {
                int len;
                int i;
                block8: {
                    i = 0;
                    len = this.items.length;
                    if (!true) break block8;
                    if (this.idleCount <= 0) return;
                    if (i >= len) break block9;
                }
                do {
                    if (this.items[i] != null) {
                        BackendConnection conn = this.items[i];
                        this.items[i] = null;
                        --this.idleCount;
                        if (!conn.isClosed()) {
                            conn.close();
                        }
                    }
                    ++i;
                    if (this.idleCount <= 0) return;
                } while (i < len);
            }
            return;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getActive() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.activeCount;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void deActive(BackendConnection c) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            --this.activeCount;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean b) {
        this.valid = b;
    }

    @Override
    public void init() {
        HeartbeatManager.addHeartbeat((HeartbeatDelayed)this.delay);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

