package com.meidusa.toolkit.net;

import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

import com.meidusa.toolkit.net.authenticate.server.AuthenticateProvider;
import com.meidusa.toolkit.util.TimeUtil;

/**
 * 
 * @author structchen
 *
 * @param <T> 认证数据包类型
 */
public abstract class AuthingableFrontendConnection extends FrontendConnection {
	private static final long AUTH_TIMEOUT = 15 * 1000L;
	protected boolean isAuthenticated;
	protected String seed;
	protected AuthenticateProvider<AuthingableFrontendConnection> authenticateProvider;
	private MessageHandler<? extends AuthingableFrontendConnection> requestHandler;	
	
	public AuthenticateProvider<AuthingableFrontendConnection> getAuthenticateProvider() {
		return authenticateProvider;
	}

	public MessageHandler<? extends AuthingableFrontendConnection> getRequestHandler() {
		return requestHandler;
	}

	public void setRequestHandler(MessageHandler<AuthingableFrontendConnection> requestHandler) {
		this.requestHandler = requestHandler;
	}

	public void setAuthenticateProvider(
			AuthenticateProvider<AuthingableFrontendConnection> authenticateProvider) {
		this.authenticateProvider = authenticateProvider;
	}

	public AuthingableFrontendConnection(SocketChannel channel) {
		super(channel);
	}

	public void setAuthenticated(boolean isAuthenticated) {
		this.isAuthenticated = isAuthenticated;
		if(isAuthenticated){
			this.setHandler(requestHandler);
		}
    }
	
	public String getSeed() {
        return seed;
    }

	public void setSeed(String seed){
		this.seed = seed;
	}
	
	@Override
    public boolean isIdleTimeout() {
        if (isAuthenticated) {
            return false;
        } else {
            return TimeUtil.currentTimeMillis() > Math.max(lastWriteTime, lastReadTime) + AUTH_TIMEOUT;
        }
    }
	 
    @Override
    public void register(Selector selector) throws IOException {
        super.register(selector);
        if(authenticateProvider != null){
	        if (!isClosed.get()) {
	        	this.setHandler(authenticateProvider);
	        	authenticateProvider.beforeAuthing(this);
	        }
        }
    }
}
