/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.packet;

import com.meidusa.toolkit.common.util.CharsetCache;
import com.meidusa.toolkit.net.IllegalPacketException;
import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class GenericIOPacketBuffer
extends AbstractPacketBuffer {
    public abstract int getHeadSize();

    public GenericIOPacketBuffer(byte[] buf) {
        super(buf);
    }

    public GenericIOPacketBuffer(int size) {
        super(size);
    }

    final void dumpHeader() {
        int i = 0;
        while (i < this.getHeadSize()) {
            String hexVal = Integer.toHexString(this.readByte(i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(String.valueOf(hexVal) + " ");
            ++i;
        }
    }

    public final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        this.readBytes(b);
        return b;
    }

    public byte[] getBytes(int offset, int len) {
        byte[] dest = new byte[len];
        System.arraycopy(this.data, offset, dest, 0, len);
        return dest;
    }

    public abstract int readFieldLength();

    public final int readInt() {
        int i = this.position;
        this.position += 4;
        return GenericIOPacketBuffer.getIntB(this.data, i);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    static int getIntB(byte[] bb, int bi) {
        return GenericIOPacketBuffer.makeInt(bb[bi + 0], bb[bi + 1], bb[bi + 2], bb[bi + 3]);
    }

    public final long readLong() {
        int i = this.position;
        this.position += 8;
        return GenericIOPacketBuffer.getLongB(this.data, i);
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    static long getLongB(byte[] bb, int bi) {
        return GenericIOPacketBuffer.makeLong(bb[bi + 0], bb[bi + 1], bb[bi + 2], bb[bi + 3], bb[bi + 4], bb[bi + 5], bb[bi + 6], bb[bi + 7]);
    }

    public int writeLengthCodedBytes(byte[] ab) {
        this.ensureCapacity(ab.length + 4);
        this.writeInt(ab == null ? 0 : ab.length);
        if (ab != null && ab.length > 0) {
            return this.writeBytes(ab, 0, ab.length);
        }
        return 0;
    }

    public byte[] readLengthCodedBytes() {
        int count = this.readInt();
        if (count == 0) {
            return new byte[0];
        }
        byte[] bts = new byte[count];
        if (count > this.remaining()) {
            throw new IllegalPacketException("packet content size error: " + count + ">" + this.remaining() + " remaining");
        }
        this.readBytes(bts, 0, count);
        return bts;
    }

    public final String readLengthCodedString(Charset charset) {
        int fieldLength = this.readFieldLength();
        if (fieldLength == 0) {
            return null;
        }
        if (fieldLength > this.remaining()) {
            throw new IllegalPacketException("fieldLength error Buffer.Remaining=" + this.remaining() + " ,but need size=" + fieldLength);
        }
        byte[] bytes = this.getBytes(fieldLength);
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes);
    }

    public final String readLengthCodedString(String encoding) {
        Charset charset = CharsetCache.getCharset((String)encoding);
        return this.readLengthCodedString(charset);
    }

    public String toString() {
        return StringUtil.dumpAsHex(this.data, this.getPosition());
    }

    public String toSuperString() {
        return super.toString();
    }

    public abstract void writeFieldLength(int var1);

    public final void writeInt(int i) {
        this.ensureCapacity(4);
        this.data[this.position++] = (byte)(i >> 24);
        this.data[this.position++] = (byte)(i >> 16);
        this.data[this.position++] = (byte)(i >> 8);
        this.data[this.position++] = (byte)(i >> 0);
    }

    public short readShort() {
        int i = this.position;
        this.position += 2;
        return GenericIOPacketBuffer.getShortB(this.data, i);
    }

    private static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    static short getShortB(byte[] bb, int bi) {
        return GenericIOPacketBuffer.makeShort(bb[bi + 0], bb[bi + 1]);
    }

    public void writeShort(short i) {
        this.ensureCapacity(2);
        this.data[this.position++] = (byte)(i >> 8);
        this.data[this.position++] = (byte)(i >> 0);
    }

    public final void writeLengthCodedString(String s, String encoding) {
        Charset charset = CharsetCache.getCharset((String)encoding);
        this.writeLengthCodedString(s, charset);
    }

    public final void writeLengthCodedString(String s, Charset charset) {
        if (s != null) {
            byte[] b = s.getBytes(charset);
            this.ensureCapacity(b.length + 9);
            this.writeFieldLength(b.length);
            this.writeBytes(b);
        } else {
            this.writeFieldLength(0);
        }
    }

    public final void writeLong(long i) {
        this.ensureCapacity(8);
        this.data[this.position++] = (byte)(i >> 56);
        this.data[this.position++] = (byte)(i >> 48);
        this.data[this.position++] = (byte)(i >> 40);
        this.data[this.position++] = (byte)(i >> 32);
        this.data[this.position++] = (byte)(i >> 24);
        this.data[this.position++] = (byte)(i >> 16);
        this.data[this.position++] = (byte)(i >> 8);
        this.data[this.position++] = (byte)(i >> 0);
    }

    public final void writeString(String s) {
        try {
            this.writeString(s, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public final void writeString(String s, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = null;
        bytes = encoding == null ? s.getBytes() : s.getBytes(encoding);
        this.ensureCapacity(bytes.length + 1 + 8);
        this.writeFieldLength(bytes.length);
        this.writeBytes(bytes);
    }

    public static void main(String[] args) {
        GenericIOPacketBuffer buffer = new GenericIOPacketBuffer(34){

            @Override
            public int getHeadSize() {
                return 0;
            }

            @Override
            public int readFieldLength() {
                return 0;
            }

            @Override
            public void writeFieldLength(int length) {
            }
        };
        buffer.writeLong(44L);
        ByteBuffer bytbuffer = ByteBuffer.allocate(32);
        bytbuffer.putLong(44L);
        System.out.println(StringUtil.dumpAsHex(bytbuffer.array(), 32));
    }
}

