/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.log4j.Logger;

public abstract class PacketInputStream
extends InputStream {
    private static Logger logger = Logger.getLogger(PacketInputStream.class);
    protected static int MAX_BUFFER_CAPACITY = Integer.getInteger("tookit.packet.max", 0x200000);
    protected static int AUTO_SHRINK_SIZE = Integer.getInteger("tookit.packet.shrink", 10240);
    protected ByteBuffer _buffer;
    protected int _length = -1;
    protected int _have = 0;
    protected static final int INITIAL_BUFFER_CAPACITY = 32;
    private double average = 32.0;
    private long times = 1L;
    private byte[] tmp = new byte[4096];

    static {
        try {
            logger.info((Object)("toolkit max input packet limit=" + MAX_BUFFER_CAPACITY + ", improved limit via set System property (-Dtookit.packet.max=newlimit)"));
            logger.info((Object)("toolkit read Buffer auto shrink size=" + AUTO_SHRINK_SIZE + ", via System property (-Dtookit.packet.shrink=newSize)"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PacketInputStream() {
        this._buffer = ByteBuffer.allocate(32);
    }

    protected void calculateAverage(int current) {
        double x;
        double j = (double)this.times / (double)(this.times + 1L);
        this.average = x = this.average * j + (double)current / (double)(this.times + 1L);
        ++this.times;
    }

    public boolean readPacket(ReadableByteChannel source) throws IOException {
        if (this._buffer.limit() == this._length) {
            this._buffer.limit(this._have);
            this._buffer.position(this._length);
            this._buffer.compact();
            if (this._length > AUTO_SHRINK_SIZE) {
                this.shrinkCapacity();
            }
            this._have -= this._length;
            this._length = this.decodeLength();
        }
        boolean completed = false;
        try {
            if (this.checkForCompletePacket()) {
                boolean bl = completed = true;
                return bl;
            }
            do {
                int got;
                if ((got = source.read(this._buffer)) == -1) {
                    throw new EOFException();
                }
                if (got == 0 && this._buffer.remaining() > 0) {
                    return false;
                }
                this._have += got;
                if (this._length == -1) {
                    this._length = this.decodeLength();
                    if (this.getHeaderSize() > this._buffer.capacity()) {
                        this.expandCapacity(this.getHeaderSize());
                    }
                }
                if (this._length < -1 || this._length > MAX_BUFFER_CAPACITY) {
                    throw new IOException("over max packet limit,current=" + this._length + " , limit=" + MAX_BUFFER_CAPACITY + ", average=" + (int)this.average + ",improved limit via set System property (-Dtookit.packet.max= newlimit)");
                }
                if (this._buffer.remaining() > 0) {
                    break;
                }
                if (this._length > 0 && this._have >= this._length) {
                    break;
                }
                if (this._length <= 0) continue;
                if (this._length - this._have > 0) {
                    this.expandCapacity(this._length - this._have);
                    continue;
                }
                this.expandCapacity(this._length);
            } while (!(completed = this.checkForCompletePacket()));
        }
        finally {
            completed = this.checkForCompletePacket();
            if (completed) {
                this.calculateAverage(this._length);
            }
        }
        return completed;
    }

    public boolean readPacket(InputStream source) throws IOException {
        if (this._buffer.limit() == this._length) {
            this._buffer.limit(this._have);
            this._buffer.position(this._length);
            this._buffer.compact();
            if (this._length > AUTO_SHRINK_SIZE) {
                this.shrinkCapacity();
            }
            this._have -= this._length;
            this._length = this.decodeLength();
        }
        boolean completed = false;
        try {
            if (this.checkForCompletePacket()) {
                boolean bl = completed = true;
                return bl;
            }
            do {
                int got;
                if ((got = source.read(this.tmp)) <= 0) {
                    throw new EOFException();
                }
                this.expandCapacity(got);
                this._buffer.put(this.tmp, 0, got);
                this._have += got;
                if (this._length != -1 || got < this.getHeaderSize()) continue;
                this._length = this.decodeLength();
                if (this._length < -1 || this._length > MAX_BUFFER_CAPACITY) {
                    throw new IOException("over max packet limit,current=" + this._length + " , limit=" + MAX_BUFFER_CAPACITY + ", average=" + (int)this.average + ",improved limit via set System property (-Dtookit.packet.max= newlimit)");
                }
                if (this._length < 0 || this._length >= this.getHeaderSize()) continue;
                throw new IOException("packet error,decode full packet size=" + this._length + ", but packet head need size=" + this.getHeaderSize());
            } while (!this.checkForCompletePacket());
            boolean bl = completed = true;
            return bl;
        }
        finally {
            if (completed) {
                this.calculateAverage(this._length);
            }
        }
    }

    private void expandCapacity(int needSize) {
        if (this._buffer.remaining() < needSize) {
            int newSize = this._buffer.capacity() << 1;
            newSize = newSize > this._length ? newSize : this._length + this.getHeaderSize();
            ByteBuffer newbuf = ByteBuffer.allocate(newSize > needSize ? newSize : needSize);
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        }
    }

    protected void shrinkCapacity() {
        int aver;
        boolean shrink = false;
        int skrinkSize = aver = (int)Math.ceil(this.average);
        if (this._buffer.capacity() > AUTO_SHRINK_SIZE) {
            shrink = true;
            skrinkSize = Runtime.getRuntime().freeMemory() < (long)MAX_BUFFER_CAPACITY ? 32 : (aver * 2 > AUTO_SHRINK_SIZE ? AUTO_SHRINK_SIZE : aver * 2);
        } else if (this._buffer.capacity() <= AUTO_SHRINK_SIZE && this._buffer.capacity() > aver * 4) {
            shrink = true;
            skrinkSize = aver * 2;
        }
        if (shrink && skrinkSize < MAX_BUFFER_CAPACITY && skrinkSize > this._have) {
            ByteBuffer newbuf = ByteBuffer.allocate(skrinkSize);
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        }
    }

    protected abstract int decodeLength();

    protected boolean checkForCompletePacket() {
        if (this._length == -1 || this._have < this._length || this._length < this.getHeaderSize()) {
            return false;
        }
        this._buffer.position(this.getHeaderSize());
        this._buffer.limit(this._length);
        return true;
    }

    @Override
    public int read() {
        int remaining = this._buffer.remaining();
        return remaining > 0 ? this._buffer.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if ((len = Math.min(len, this._buffer.remaining())) == 0) {
            return -1;
        }
        this._buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        return this._buffer.remaining();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public int getLength() {
        return this._length;
    }

    @Override
    public void mark(int readAheadLimit) {
    }

    @Override
    public void reset() {
        this._buffer.position(this.getHeaderSize());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("buffer:").append(this._buffer).append(",length:").append(this._length).append(",have:").append(this._have);
        return buffer.toString();
    }

    public abstract int getHeaderSize();
}

