/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionObserver;
import com.meidusa.toolkit.net.NetEventHandler;
import com.meidusa.toolkit.net.util.ConMgrStats;
import com.meidusa.toolkit.net.util.LoopingThread;
import com.meidusa.toolkit.net.util.MemoryQueue;
import com.meidusa.toolkit.net.util.Queue;
import com.meidusa.toolkit.net.util.Reporter;
import com.meidusa.toolkit.net.util.Tuple;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ConnectionManager
extends LoopingThread
implements Reporter,
Initialisable {
    private static final AtomicLong counter = new AtomicLong();
    protected static Logger logger = Logger.getLogger(ConnectionManager.class);
    protected static final int SELECT_LOOP_TIME = 1000;
    protected static final int CONNECTION_ESTABLISHED = 0;
    protected static final int CONNECTION_FAILED = 1;
    protected static final int CONNECTION_CLOSED = 2;
    protected static final int CONNECTION_AUTHENTICATE_SUCCESS = 3;
    protected static final int CONNECTION_AUTHENTICATE_FAILD = 4;
    protected Selector _selector;
    private List<NetEventHandler> _handlers = new ArrayList<NetEventHandler>();
    protected ArrayList<ConnectionObserver> _observers = new ArrayList();
    protected ConMgrStats _stats;
    protected Queue<Tuple<Connection, Exception>> _deathq = new MemoryQueue<Tuple<Connection, Exception>>();
    protected Queue<Tuple<NetEventHandler, Integer>> _registerQueue = new MemoryQueue<Tuple<NetEventHandler, Integer>>();
    protected int _runtimeExceptionCount;
    protected long idleCheckTime = 5000L;
    private long lastIdleCheckTime = 0L;
    protected long maxQueueSizePerClient = -1L;
    static BlockingQueue<NetEventHandler> pingQueue = new LinkedBlockingQueue<NetEventHandler>(1000000);

    static {
        PingThread pingThread = new PingThread();
        pingThread.setName("Toolkit-Ping-Thread");
        pingThread.setDaemon(true);
        pingThread.start();
    }

    public void setIdleCheckTime(long idleCheckTime) {
        this.idleCheckTime = idleCheckTime;
    }

    public long getIdleCheckTime() {
        return this.idleCheckTime;
    }

    public long getMaxQueueSizePerClient() {
        return this.maxQueueSizePerClient;
    }

    public void setMaxQueueSizePerClient(long maxQueueSizePerClient) {
        this.maxQueueSizePerClient = maxQueueSizePerClient;
    }

    @Override
    public void appendReport(StringBuilder report, long now, long sinceLast, boolean reset, Level level) {
        report.append("* ").append(this.getName()).append("\r\n");
        report.append("    - Registed Connection size: ").append(this._selector.keys().size()).append("\r\n");
        report.append("    - created Connection size: ").append(this._stats.connects.get()).append("\r\n");
        report.append("    - disconnected Connection size: ").append(this._stats.disconnects.get()).append("\r\n");
        if (reset) {
            this._stats = new ConMgrStats();
        }
    }

    public ConnectionManager() throws IOException {
        this.setName("Toolkit-ConnectionManager-" + counter.addAndGet(1L));
        this._selector = SelectorProvider.provider().openSelector();
        this._stats = new ConMgrStats();
    }

    public ConnectionManager(String managerName) throws IOException {
        super(managerName);
        this._selector = SelectorProvider.provider().openSelector();
        this._stats = new ConMgrStats();
        this.setDaemon(true);
    }

    @Override
    protected void handleIterateFailure(Throwable e) {
        logger.error((Object)"handle iterate error", e);
    }

    @Override
    protected void iterate() {
        Tuple<Connection, Exception> deathTuple;
        long iterStamp = System.currentTimeMillis();
        while ((deathTuple = this._deathq.getNonBlocking()) != null) {
            try {
                ((Connection)deathTuple.left).close((Exception)deathTuple.right);
            }
            catch (Exception e) {
                logger.error((Object)("close connection error conn=" + deathTuple.left), (Throwable)e);
            }
        }
        if (this.idleCheckTime > 0L && iterStamp - this.lastIdleCheckTime >= this.idleCheckTime) {
            this.lastIdleCheckTime = iterStamp;
            for (NetEventHandler handler : this._handlers) {
                Connection conn2;
                if (handler.checkIdle(iterStamp)) {
                    if (handler instanceof Connection) {
                        conn2 = (Connection)handler;
                        long idleMillis = iterStamp - conn2._lastEvent;
                        logger.info((Object)("Disconnecting non-communicative connection [conn=" + conn2 + ",id=" + conn2.getId() + ", manager=" + this.getName() + ", idle=" + idleMillis + "ms]."));
                        this.closeConnection((Connection)handler, null);
                    }
                } else if (handler.needPing(iterStamp)) {
                    try {
                        pingQueue.offer(handler, 1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException conn2) {
                        // empty catch block
                    }
                }
                if (this.maxQueueSizePerClient <= 0L || !(handler instanceof Connection)) continue;
                conn2 = (Connection)handler;
                if (handler.getQueueSize() <= this.maxQueueSizePerClient) continue;
                logger.info((Object)("Disconnecting message flood connection [conn=" + conn2 + ",id=" + conn2.getId() + ", queueSize=" + handler.getQueueSize()));
                this.closeConnection((Connection)handler, null);
            }
        }
        Tuple<NetEventHandler, Integer> registerHandler = null;
        while ((registerHandler = this._registerQueue.getNonBlocking()) != null) {
            if (registerHandler.left instanceof Connection) {
                Connection connection = (Connection)registerHandler.left;
                this.registerConnection(connection, (Integer)registerHandler.right);
                if (connection.getChannel() == null || !connection.getChannel().isOpen()) continue;
                this._handlers.add(connection);
                continue;
            }
            this._handlers.add((NetEventHandler)registerHandler.left);
        }
        Set<SelectionKey> ready = null;
        try {
            int ecount = this._selector.select(1000L);
            ready = this._selector.selectedKeys();
            if (ecount == 0) {
                if (ready.size() == 0) {
                    return;
                }
                logger.warn((Object)("select() returned no selected sockets, but there are " + ready.size() + " in the ready set."));
            }
        }
        catch (IOException ioe) {
            logger.warn((Object)"Failure select()ing.", (Throwable)ioe);
            return;
        }
        catch (RuntimeException re) {
            logger.warn((Object)"Failure select()ing.", (Throwable)re);
            if (this._runtimeExceptionCount++ >= 20) {
                logger.warn((Object)"Too many errors, bailing.");
                this.shutdown();
            }
            return;
        }
        this._runtimeExceptionCount = 0;
        for (SelectionKey selkey : ready) {
            try {
                NetEventHandler handler;
                block26: {
                    handler = null;
                    handler = (NetEventHandler)selkey.attachment();
                    if (handler == null) {
                        logger.warn((Object)("Received network event but have no registered handler [selkey=" + selkey + "]."));
                        selkey.cancel();
                        continue;
                    }
                    if (selkey.isWritable()) {
                        try {
                            handler.doWrite();
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Error processing network data: " + handler + "."), (Throwable)e);
                            if (handler == null || !(handler instanceof Connection)) break block26;
                            this.closeConnection((Connection)handler, e);
                        }
                    }
                }
                if (!selkey.isReadable() && !selkey.isAcceptable()) continue;
                handler.handleEvent(iterStamp);
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
        ready.clear();
    }

    void closeConnection(Connection conn, Exception exception) {
        if (!conn.isClosed()) {
            this._deathq.append(new Tuple<Connection, Exception>(conn, exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Selector selector = this._selector;
        synchronized (selector) {
            Set<SelectionKey> keys = this._selector.keys();
            for (SelectionKey key : keys) {
                Object object = key.attachment();
                if (!(object instanceof Connection)) continue;
                Connection conn = (Connection)object;
                this.closeConnection(conn, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionObserver(ConnectionObserver observer) {
        ArrayList<ConnectionObserver> arrayList = this._observers;
        synchronized (arrayList) {
            this._observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionObserver(ConnectionObserver observer) {
        ArrayList<ConnectionObserver> arrayList = this._observers;
        synchronized (arrayList) {
            this._observers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyObservers(int code, Connection conn, Object arg1) {
        ArrayList<ConnectionObserver> arrayList = this._observers;
        synchronized (arrayList) {
            for (ConnectionObserver obs : this._observers) {
                switch (code) {
                    case 0: {
                        obs.connectionEstablished(conn);
                        break;
                    }
                    case 1: {
                        obs.connectionFailed(conn, (Exception)arg1);
                        break;
                    }
                    case 2: {
                        obs.connectionClosed(conn);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid code supplied to notifyObservers: " + code);
                    }
                }
            }
        }
    }

    public void postRegisterNetEventHandler(NetEventHandler handler, int key) {
        this._registerQueue.append(new Tuple<NetEventHandler, Integer>(handler, key));
        this._selector.wakeup();
    }

    protected void afterRegisterConnection(Connection connection) {
        this.notifyObservers(0, connection, null);
    }

    protected void registerConnection(Connection connection, int key) {
        SocketChannel channel = connection.getChannel();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.getName() + "] registed Connection[" + connection.getId() + "] connected!"));
        }
        SelectionKey selkey = null;
        try {
            if (!(channel instanceof SelectableChannel)) {
                try {
                    logger.warn((Object)("Provided with un-selectable socket as result of accept(), can't cope [channel=" + channel + "]."));
                }
                catch (Error err) {
                    logger.warn((Object)"Un-selectable channel also couldn't be printed.");
                }
                if (channel != null) {
                    channel.close();
                }
                return;
            }
            ((SelectableChannel)channel).configureBlocking(false);
            selkey = ((SelectableChannel)channel).register(this._selector, key, connection);
            connection.setConnectionManager(this);
            connection.setSelectionKey(selkey);
            this.configConnection(connection);
            this._stats.connects.incrementAndGet();
            connection.init();
            this.afterRegisterConnection(connection);
            this._selector.wakeup();
            return;
        }
        catch (IOException ioe) {
            logger.error((Object)("register connection error: " + ioe));
            if (selkey != null) {
                selkey.attach(null);
                selkey.cancel();
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException ioe2) {
                    logger.warn((Object)("Failed closing aborted connection: " + ioe2));
                }
            }
            return;
        }
    }

    protected void configConnection(Connection connection) throws SocketException {
    }

    protected void connectionClosed(Connection conn) {
        this._handlers.remove(conn);
        this._stats.disconnects.incrementAndGet();
        this.notifyObservers(2, conn, null);
    }

    protected void connectionFailed(Connection conn, Exception ioe) {
        this._handlers.remove(conn);
        this._stats.disconnects.incrementAndGet();
        this.notifyObservers(1, conn, ioe);
    }

    public void init() throws InitialisationException {
    }

    public int getSize() {
        return this._handlers.size();
    }

    static class PingThread
    extends Thread {
        PingThread() {
        }

        @Override
        public void run() {
            try {
                NetEventHandler handler = pingQueue.take();
                long now = System.currentTimeMillis();
                if (handler.needPing(now)) {
                    handler.ping(now);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

