/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoopingThread
extends Thread {
    private static Logger log = Logger.getLogger(LoopingThread.class);
    protected boolean _running = true;

    public LoopingThread() {
    }

    public LoopingThread(String name) {
        super(name);
    }

    public synchronized void shutdown() {
        this._running = false;
        if (this != Thread.currentThread()) {
            this.kick();
        }
    }

    @Override
    public void run() {
        Level level = log.getLevel();
        log.setLevel(Level.INFO);
        log.info((Object)(String.valueOf(this.getName()) + " LoopingThread willStart...."));
        log.setLevel(level);
        try {
            this.willStart();
            while (this.isRunning()) {
                try {
                    this.iterate();
                }
                catch (Throwable e) {
                    this.handleIterateFailure(e);
                }
            }
        }
        finally {
            this.didShutdown();
        }
    }

    public synchronized boolean isRunning() {
        return this._running;
    }

    protected void kick() {
    }

    protected void willStart() {
    }

    protected void iterate() {
        throw new RuntimeException("Derived class must implement iterate().");
    }

    protected void handleIterateFailure(Throwable e) {
        log.error((Object)"error:", e);
        this.shutdown();
    }

    protected void didShutdown() {
    }
}

