/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.packet;

import com.meidusa.toolkit.net.buffer.BufferPool;
import com.meidusa.toolkit.net.packet.PacketBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AbstractPacketBuffer
implements PacketBuffer {
    public static final BufferPool BUFFER_POOL = new BufferPool(0x4000000, 8192);
    protected byte[] data;
    private int length;
    protected int position;

    public AbstractPacketBuffer(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public AbstractPacketBuffer(int size) {
        this.data = new byte[size];
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        byte[] bts = new byte[this.position];
        System.arraycopy(this.data, 0, bts, 0, this.position);
        ByteBuffer buffer = null;
        if (bts.length <= BUFFER_POOL.getChunkSize()) {
            buffer = BUFFER_POOL.allocate();
            buffer.put(bts);
            buffer.flip();
        } else {
            buffer = ByteBuffer.wrap(bts);
        }
        return buffer;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public byte readByte() {
        return this.data[this.position++];
    }

    @Override
    public byte readByte(int i) {
        return this.data[i];
    }

    @Override
    public void writeByte(byte b) {
        this.ensureCapacity(1);
        this.data[this.position++] = b;
    }

    @Override
    public int writeBytes(byte[] ab) {
        return this.writeBytes(ab, 0, ab.length);
    }

    public void readBytes(byte[] ab) {
        this.readBytes(ab, 0, ab.length);
    }

    public int writeBytes(byte[] ab, int offset, int len) {
        this.ensureCapacity(len);
        System.arraycopy(ab, offset, this.data, this.position, len);
        this.position += len;
        return len;
    }

    @Override
    public int readBytes(byte[] ab, int offset, int len) {
        System.arraycopy(this.data, this.position, ab, offset, len);
        this.position += len;
        return len;
    }

    protected void ensureCapacity(int i) {
        if (this.data.length - this.position < i) {
            int size = Math.max(this.data.length << 1, i + this.position);
            byte[] newData = new byte[size];
            System.arraycopy(this.data, 0, newData, 0, this.position);
            this.data = newData;
        }
    }

    protected void init() {
    }

    @Override
    public synchronized void reset() {
        this.position = 0;
    }

    public byte[] readRemaining() {
        byte[] bts = new byte[this.data.length - this.position];
        System.arraycopy(this.data, this.position, bts, 0, bts.length);
        return bts;
    }

    @Override
    public int remaining() {
        return this.data.length - this.position;
    }

    public boolean hasRemaining() {
        return this.data.length - this.position > 0;
    }

    public void skip(int bytes) {
        this.position += bytes;
    }

    @Override
    public InputStream asInputStream() {
        return new InputStream(){

            @Override
            public int available() {
                return AbstractPacketBuffer.this.remaining();
            }

            @Override
            public int read() {
                if (AbstractPacketBuffer.this.hasRemaining()) {
                    return AbstractPacketBuffer.this.readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                int remaining = AbstractPacketBuffer.this.remaining();
                if (remaining > 0) {
                    int readBytes = Math.min(remaining, len);
                    AbstractPacketBuffer.this.readBytes(b, off, readBytes);
                    return readBytes;
                }
                return -1;
            }

            @Override
            public synchronized void reset() {
                AbstractPacketBuffer.this.reset();
            }

            @Override
            public long skip(long n) {
                int bytes = n > Integer.MAX_VALUE ? AbstractPacketBuffer.this.remaining() : Math.min(AbstractPacketBuffer.this.remaining(), (int)n);
                AbstractPacketBuffer.this.skip(bytes);
                return bytes;
            }
        };
    }

    @Override
    public OutputStream asOutputStream() {
        return new OutputStream(){

            @Override
            public void write(byte[] b, int off, int len) {
                AbstractPacketBuffer.this.writeBytes(b, off, len);
            }

            @Override
            public void write(int b) {
                AbstractPacketBuffer.this.writeByte((byte)b);
            }
        };
    }

    public void writeFixedLengthString(String string, String encoding, int length) {
        if (string == null) {
            this.writeBytes(new byte[length]);
        } else {
            byte[] strBytes = null;
            if (encoding != null) {
                try {
                    strBytes = string.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    strBytes = string.getBytes();
                }
            } else {
                strBytes = string.getBytes();
            }
            if (length <= strBytes.length) {
                this.writeBytes(strBytes, 0, length);
            } else {
                this.writeBytes(strBytes);
                this.writeBytes(new byte[length - strBytes.length]);
            }
        }
    }

    public String readFixedLengthString(String encoding, int length) {
        if (length > this.remaining()) {
            throw new ArrayIndexOutOfBoundsException("packet remaining=" + this.remaining() + " but need size=" + length);
        }
        byte[] strBytes = new byte[length];
        this.readBytes(strBytes, 0, length);
        int nullIndex = -1;
        int noNullLength = 0;
        int i = strBytes.length - 1;
        while (i >= 0) {
            if (strBytes[i] != 0) {
                nullIndex = i;
                break;
            }
            --i;
        }
        if (nullIndex == 0) {
            return null;
        }
        noNullLength = nullIndex == -1 ? length : nullIndex + 1;
        if (encoding == null) {
            return new String(strBytes, 0, noNullLength);
        }
        try {
            return new String(strBytes, 0, noNullLength, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(strBytes, 0, noNullLength);
        }
    }

    public static void main(String[] args) {
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[4] = 12;
        byArray[5] = 1;
        byte[] byts = byArray;
        AbstractPacketBuffer buffer = new AbstractPacketBuffer(byts);
        String ms = buffer.readFixedLengthString(null, 7);
        System.out.println(ms);
    }
}

