package com.meidusa.toolkit.net.util;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class InetAddressUtil {
	public static int pack(byte[] bytes) {
		int val = 0;
		for (int i = 0; i < bytes.length; i++) {
			val <<= 8;
			val |= bytes[i];
		}
		return val;
	}

	public static  byte[] unpack(int bytes) {
		return new byte[] { (byte) 
				((bytes >>> 24) & 0xff),
				(byte) ((bytes >>> 16) & 0xff), 
				(byte) ((bytes >>> 8) & 0xff),
				(byte) ((bytes) & 0xff) };
	}

	public static void main(String[] args) throws Exception {
		long time = System.nanoTime();
		for (int i = 0; i < 1000000; i++) {
			byte[] bts = InetAddress.getByName("127.0.0.1").getAddress();
		}
		System.err.println(TimeUnit.MILLISECONDS.convert(System.nanoTime()
				- time, TimeUnit.NANOSECONDS));
	}

}
