package com.meidusa.toolkit.net.packet;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author struct
 */
@SuppressWarnings("unchecked")
public abstract class AbstractPacket<T extends AbstractPacketBuffer> implements
		Packet {
	private static final long serialVersionUID = 1L;
	private static Map<Class,Constructor> intTypeMap = new HashMap<Class,Constructor>();
	private static Map<Class,Constructor> byteTypeMap = new HashMap<Class,Constructor>();
	public void init(byte[] buffer) {
		T packetBuffer = constractorBuffer(buffer);
		packetBuffer.init();
		init(packetBuffer);
	}
	
	protected abstract void initHead(T buffer);

	/**
	 * ݰ(ͷ+,ͷԺӦýBufferpostionõ)
	 */
	public void init(T buffer){
		initHead(buffer);
		readBody(buffer);
		afterInit(buffer);
	}

	protected abstract void readBody(T buffer);

	/**
	 * ʼԺ
	 */
	protected void afterInit(T buffer) {
	}

	public ByteBuffer toByteBuffer() {
		try {
			int bufferSize = calculatePacketSize();
			T packetBuffer = constractorBuffer(bufferSize);
			packetBuffer.init();
			return toBuffer(packetBuffer).toByteBuffer();
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}

	public byte[] toByteArray(){
		try {
			int bufferSize = calculatePacketSize();
			T packetBuffer = constractorBuffer(bufferSize);
			packetBuffer.init();
			toBuffer(packetBuffer);
			byte[] result =  new byte[packetBuffer.position];
			System.arraycopy(packetBuffer.data, 0, result, 0, packetBuffer.position);
			return result;
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}
	
	private T constractorBuffer(int bufferSize) {
		T buffer = null;
		try {
			Constructor<T> constractor = intTypeMap.get(getPacketBufferClass());
			if(constractor == null){
				synchronized (intTypeMap) {
					constractor = intTypeMap.get(getPacketBufferClass());
					if(constractor == null){
						constractor = getPacketBufferClass().getConstructor(int.class);
						intTypeMap.put(getPacketBufferClass(), constractor);
					}
				}
			}
			
			buffer = constractor.newInstance(bufferSize);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buffer;
	}

	/**
	 * <pre>
	 *  ÷{@link #write2Buffer(PacketBuffer)} д뵽ָbuffer 
	 *  ҵ{@link #afterPacketWritten(PacketBuffer)}
	 * </pre>
	 */
	private T toBuffer(T buffer) throws UnsupportedEncodingException {
		write2Buffer(buffer);
		afterPacketWritten(buffer);
		return buffer;
	}

	/**
	 * ͷϢװ
	 */
	protected void write2Buffer(T buffer)
			throws UnsupportedEncodingException{
		writeHead(buffer);
		writeBody(buffer);
	}

	protected abstract void writeBody(T buffer) throws UnsupportedEncodingException ;
	protected abstract void writeHead(T buffer);

	/**
	 * <pre>
	 * д֮һҪbufferָλָĩβһλãܳλã
	 * һǼݰܳ,Ҫݰдɵ
	 * </pre>
	 */
	protected abstract void afterPacketWritten(T buffer);

	/**
	 * packetĴС̫˷ڴ棬̫СӰ
	 */
	protected abstract int calculatePacketSize();

	private T constractorBuffer(byte[] buffer) {
		T packetbuffer = null;
		try {
			
			Constructor<T> constractor = byteTypeMap.get(getPacketBufferClass());
			if(constractor == null){
				synchronized (byteTypeMap) {
					constractor = byteTypeMap.get(getPacketBufferClass());
					if(constractor == null){
						constractor = getPacketBufferClass().getConstructor(byte[].class);
						byteTypeMap.put(getPacketBufferClass(), constractor);
					}
				}
			}
			
			packetbuffer = constractor.newInstance(buffer);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return packetbuffer;
	}

	protected abstract Class<T> getPacketBufferClass();

	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
