/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.packet;

import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.packet.Packet;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractPacket<T extends AbstractPacketBuffer>
implements Packet {
    private static final long serialVersionUID = 1L;
    private static Map<Class, Constructor> intTypeMap = new HashMap<Class, Constructor>();
    private static Map<Class, Constructor> byteTypeMap = new HashMap<Class, Constructor>();

    @Override
    public void init(byte[] buffer) {
        T packetBuffer = this.constractorBuffer(buffer);
        ((AbstractPacketBuffer)packetBuffer).init();
        this.init(packetBuffer);
    }

    protected abstract void initHead(T var1);

    public void init(T buffer) {
        this.initHead(buffer);
        this.readBody(buffer);
        this.afterInit(buffer);
    }

    protected abstract void readBody(T var1);

    protected void afterInit(T buffer) {
    }

    @Override
    public ByteBuffer toByteBuffer() {
        try {
            int bufferSize = this.calculatePacketSize();
            T packetBuffer = this.constractorBuffer(bufferSize);
            ((AbstractPacketBuffer)packetBuffer).init();
            return ((AbstractPacketBuffer)this.toBuffer(packetBuffer)).toByteBuffer();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T constractorBuffer(int bufferSize) {
        AbstractPacketBuffer buffer = null;
        try {
            Constructor<T> constractor = intTypeMap.get(this.getPacketBufferClass());
            if (constractor == null) {
                Map<Class, Constructor> map = intTypeMap;
                synchronized (map) {
                    constractor = intTypeMap.get(this.getPacketBufferClass());
                    if (constractor == null) {
                        constractor = this.getPacketBufferClass().getConstructor(Integer.TYPE);
                        intTypeMap.put(this.getPacketBufferClass(), constractor);
                    }
                }
            }
            buffer = (AbstractPacketBuffer)constractor.newInstance(bufferSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)buffer;
    }

    private T toBuffer(T buffer) throws UnsupportedEncodingException {
        this.write2Buffer(buffer);
        this.afterPacketWritten(buffer);
        return buffer;
    }

    protected void write2Buffer(T buffer) throws UnsupportedEncodingException {
        this.writeHead(buffer);
        this.writeBody(buffer);
    }

    protected abstract void writeBody(T var1) throws UnsupportedEncodingException;

    protected abstract void writeHead(T var1);

    protected abstract void afterPacketWritten(T var1);

    protected abstract int calculatePacketSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T constractorBuffer(byte[] buffer) {
        AbstractPacketBuffer packetbuffer = null;
        try {
            Constructor<T> constractor = byteTypeMap.get(this.getPacketBufferClass());
            if (constractor == null) {
                Map<Class, Constructor> map = byteTypeMap;
                synchronized (map) {
                    constractor = byteTypeMap.get(this.getPacketBufferClass());
                    if (constractor == null) {
                        constractor = this.getPacketBufferClass().getConstructor(byte[].class);
                        byteTypeMap.put(this.getPacketBufferClass(), constractor);
                    }
                }
            }
            packetbuffer = (AbstractPacketBuffer)constractor.newInstance(new Object[]{buffer});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)packetbuffer;
    }

    protected abstract Class<T> getPacketBufferClass();

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

